/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder.domain;

import cn.net.vidyo.framework.builder.domain.IColumnType;

public enum DbColumnType implements IColumnType
{
    BASE_BYTE("byte", null, "new byte[0]", "null"),
    BASE_SHORT("short", null, "0"),
    BASE_CHAR("char", null, "''"),
    BASE_INT("int", null, "0"),
    BASE_LONG("long", null, "0L", "0"),
    BASE_FLOAT("float", null, "0"),
    BASE_DOUBLE("double", null, "0"),
    BASE_BOOLEAN("boolean", null, "false"),
    BYTE("Byte", null, "new byte[0]", "null"),
    SHORT("Short", null, "0"),
    CHARACTER("Character", null, "\"\"", "''"),
    INTEGER("Integer", null, "0"),
    LONG("Long", null, "0L", "0"),
    FLOAT("Float", null, "0"),
    DOUBLE("Double", null, "0"),
    BOOLEAN("Boolean", null, "false"),
    STRING("String", null, "\"\"", "''"),
    DATE_SQL("Date", "java.sql.Date", "new java.sql.Date()"),
    TIME("Time", "java.sql.Time", "new java.sql.Time()"),
    TIMESTAMP("Timestamp", "java.sql.Timestamp", "new java.sql.Timestamp()"),
    BLOB("Blob", "java.sql.Blob", "null"),
    CLOB("Clob", "java.sql.Clob", "null"),
    LOCAL_DATE("LocalDate", "java.time.LocalDate", "java.time.LocalDate,now()"),
    LOCAL_TIME("LocalTime", "java.time.LocalTime", "java.time.LocalTime.now()"),
    YEAR("Year", "java.time.Year", "java.time.Year.now()"),
    YEAR_MONTH("YearMonth", "java.time.YearMonth", "java.time.YearMonth.now()"),
    LOCAL_DATE_TIME("LocalDateTime", "java.time.LocalDateTime", "java.time.LocalDateTime.now()"),
    INSTANT("Instant", "java.time.Instant", "java.time.Instant.now()"),
    MAP("Map", "java.util.Map", "new java.util.HashMap()"),
    BYTE_ARRAY("byte[]", null, "new byte[0]"),
    OBJECT("Object", null, "null"),
    DATE("Date", "java.util.Date", "new java.util.Date()"),
    BIG_INTEGER("BigInteger", "java.math.BigInteger", "new java.math.BigInteger()"),
    BIG_DECIMAL("BigDecimal", "java.math.BigDecimal", "new java.math.BigDecimal()");

    private final String type;
    private final String pkg;
    private String defaultValue = "";
    private String tsdefaultValue = "";

    private DbColumnType(String type, String pkg, String defaultValue) {
        this.type = type;
        this.pkg = pkg;
        this.defaultValue = defaultValue;
        this.tsdefaultValue = defaultValue;
    }

    private DbColumnType(String type, String pkg, String defaultValue, String tsdefaultValue) {
        this.type = type;
        this.pkg = pkg;
        this.defaultValue = defaultValue;
        this.tsdefaultValue = tsdefaultValue;
    }

    private DbColumnType(String type, String pkg) {
        this.type = type;
        this.pkg = pkg;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getPkg() {
        return this.pkg;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public String getTsdefaultValue() {
        return this.tsdefaultValue;
    }

    public void setTsdefaultValue(String tsdefaultValue) {
        this.tsdefaultValue = tsdefaultValue;
    }
}

