/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder.config;

import cn.net.vidyo.framework.builder.config.Module;
import cn.net.vidyo.framework.builder.config.ProjectItem;
import cn.net.vidyo.framework.builder.domain.DateType;
import cn.net.vidyo.framework.builder.template.ITemplate;
import cn.net.vidyo.framework.builder.template.Template;
import java.io.File;
import org.springframework.util.Assert;

public class Project
extends ProjectItem {
    private DateType dateType = DateType.TIME_PACK;
    public static final String ROOT_MODULE_NAME = "root";

    public Module addRootModule() {
        Module module = new Module();
        module.setName(ROOT_MODULE_NAME);
        module.setComment(ROOT_MODULE_NAME);
        module.setOutpath("");
        module.setNamespace("");
        module.setOverrideModel(this.overrideModel);
        this.addModule(module);
        return module;
    }

    public Module getRootModule() {
        return this.getModule(ROOT_MODULE_NAME);
    }

    public Project addDefaultTemplate() {
        Module rootModule = this.getRootModule();
        if (rootModule == null) {
            rootModule = this.addRootModule();
        }
        this.addModuleTemplate(rootModule.getName(), this.getDefaultEntityTemplate(), this.getDefaultDaoTemplate(), this.getDefaultMapperXmlTemplate(), this.getDefaultAutoServiceTemplate(), this.getDefaultAutoServiceImplTemplate(), this.getDefaultServiceTemplate(), this.getDefaultServiceImplTemplate(), this.getDefaultConditionTemplate(), this.getDefaultConverterTemplate(), this.getDefaultAutoControllerTemplate(), this.getDefaultUiApiTemplate());
        return this;
    }

    public Project addRootModuleTemplate(ITemplate ... templates) {
        return this.addModuleTemplate(ROOT_MODULE_NAME, templates);
    }

    public Project addModuleTemplate(String moduleName, ITemplate ... templates) {
        Module module = this.getModule(moduleName);
        Assert.notNull((Object)module, (String)("\u6ca1\u6709\u8fd9\u4e2a\u6a21\u5757" + moduleName));
        module.addTemplate(templates);
        return this;
    }

    public Template getDefaultEntityTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/entity.java.ftl");
        template.setName("entity");
        template.setPath("/data/entity");
        template.setNamespace(".data.entity");
        template.setPrefix("");
        template.setPostfix(".java");
        return template;
    }

    public Template getDefaultDaoTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/dao.java.ftl");
        template.setName("dao");
        template.setPath("/data/auto/dao");
        template.setNamespace(".data.auto.dao");
        template.setPrefix("");
        template.setPostfix("Dao.java");
        return template;
    }

    public Template getDefaultAutoServiceTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/autoservice.java.ftl");
        template.setName("autoservice");
        template.setPath("/data/auto/service");
        template.setNamespace(".data.auto.service");
        template.setPrefix("");
        template.setPostfix("AutoService.java");
        return template;
    }

    public Template getDefaultAutoServiceImplTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/autoserviceImpl.java.ftl");
        template.setName("autoserviceImpl");
        template.setPath("/data/auto/service/impl");
        template.setNamespace(".data.auto.service.impl");
        template.setPrefix("");
        template.setPostfix("AutoServiceImpl.java");
        return template;
    }

    public Template getDefaultServiceTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/service.java.ftl");
        template.setName("service");
        template.setPath("/data/service");
        template.setNamespace(".data.service");
        template.setPrefix("");
        template.setPostfix("Service.java");
        return template;
    }

    public Template getDefaultServiceImplTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/serviceImpl.java.ftl");
        template.setName("serviceImpl");
        template.setPath("/data/service/impl");
        template.setNamespace(".data.service.impl");
        template.setPrefix("");
        template.setPostfix("ServiceImpl.java");
        return template;
    }

    public Template getDefaultOneServiceTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/oneservice.java.ftl");
        template.setName("oneservice");
        template.setPath("/data/service");
        template.setNamespace(".data.service");
        template.setPrefix("");
        template.setPostfix("Service.java");
        return template;
    }

    public Template getDefaultMapperXmlTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/mapper.xml.ftl");
        template.setName("mapper");
        template.setPath("/resources/mapper");
        template.setPrefix("");
        template.setPostfix("Mapper.xml");
        return template;
    }

    public Template getDefaultConditionTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/condition.java.ftl");
        template.setName("condition");
        template.setPath("/data/condition");
        template.setNamespace(".data.condition");
        template.setPrefix("");
        template.setPostfix("Condition.java");
        return template;
    }

    public Template getDefaultConverterTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/converter.java.ftl");
        template.setName("converter");
        template.setPath("/data/converter");
        template.setNamespace(".data.converter");
        template.setPrefix("");
        template.setPostfix("Converter.java");
        return template;
    }

    public Template getDefaultAutoControllerTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/autocontroller.java.ftl");
        template.setName("autocontroller");
        template.setPath("/web/auto");
        template.setNamespace(".web.auto");
        template.setPrefix("");
        template.setPostfix("AutoController.java");
        return template;
    }

    public Template getDefaultUiApiTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/web.ui.api.ts.ftl");
        template.setName("uiapi");
        template.setPath("/web/ui/auto");
        template.setNamespace(".web.ui.auto");
        template.setPrefix("");
        template.setPostfix(".ts");
        return template;
    }

    public Project addModule(Module ... modules) {
        for (Module module : modules) {
            if (module.getNamespace().length() > 0) {
                module.setFullNamespace(this.namespace + "." + module.getNamespace());
            } else {
                module.setFullNamespace(this.namespace);
            }
            if (module.getOutpath().length() > 0) {
                module.setFullOutpath(this.getOutpath() + File.separator + module.getOutpath());
                continue;
            }
            module.setFullOutpath(this.getOutpath());
        }
        this.addItem(modules);
        return this;
    }

    public Module getModule(String name) {
        ProjectItem item = this.getItem(name);
        return (Module)item;
    }

    public Module getModuleByTableName(String tableName) {
        for (ProjectItem item : this.items) {
            Module module = (Module)item;
            if (!module.containsByTableName(this.name)) continue;
            return module;
        }
        return null;
    }

    public Project addTableName(String moduleName, String ... tableNames) {
        Module module = this.getModule(moduleName);
        if (module == null) {
            module = new Module();
            module.setName(moduleName);
            module.setComment(moduleName);
            module.setOutpath(moduleName);
            module.setNamespace(moduleName);
            module.setOverrideModel(this.overrideModel);
            this.addItem(module);
        }
        module.addTableName(tableNames);
        return this;
    }

    public DateType getDateType() {
        return this.dateType;
    }

    public void setDateType(DateType dateType) {
        this.dateType = dateType;
    }
}

