/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder;

import cn.net.vidyo.framework.builder.config.DataSourceConfig;
import cn.net.vidyo.framework.builder.config.GlobalConfig;
import cn.net.vidyo.framework.builder.config.ModelExtend;
import cn.net.vidyo.framework.builder.config.Module;
import cn.net.vidyo.framework.builder.config.Project;
import cn.net.vidyo.framework.builder.config.ProjectItem;
import cn.net.vidyo.framework.builder.engine.FreemakerTemplateEngine;
import cn.net.vidyo.framework.builder.meta.TableSchema;
import cn.net.vidyo.framework.builder.query.DefaultDatabaseQuery;
import cn.net.vidyo.framework.builder.template.ITemplate;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class Generator {
    DataSourceConfig dataSourceConfig;
    LinkedList<ModelExtend> modelExtends = new LinkedList();
    public static final String AUTHOR = "author";
    public static final String NAMESPACE = "namespace";
    public static final String OUT_PATH = "outpath";
    public static final String PROJECT = "project";
    public static final String MODULE = "module";
    public static final String TABLE = "table";
    public static final String ENTITYNAME = "";

    public Generator setDataSource(String url, String username, String password) {
        if (this.dataSourceConfig == null) {
            this.dataSourceConfig = new DataSourceConfig();
        }
        this.dataSourceConfig.setUrl(url);
        this.dataSourceConfig.setUsername(username);
        this.dataSourceConfig.setPassword(password);
        return this;
    }

    public Generator addExtend(ModelExtend ... modelExtends) {
        for (ModelExtend modelExtend : modelExtends) {
            this.modelExtends.add(modelExtend);
        }
        return this;
    }

    public void go(Project project) {
        FreemakerTemplateEngine engine = new FreemakerTemplateEngine();
        engine.init();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(PROJECT, project);
        for (ProjectItem projectItem : project.getItems().toArray(new ProjectItem[0])) {
            Module module = (Module)projectItem;
            model.put(MODULE, module);
        }
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setDateType(project.getDateType());
        globalConfig.setDataSourceConfig(this.dataSourceConfig);
        DefaultDatabaseQuery defaultDatabaseQuery = new DefaultDatabaseQuery(globalConfig);
        List<TableSchema> tableSchemas = defaultDatabaseQuery.queryTables();
        for (TableSchema tableSchema : tableSchemas) {
            model.put(TABLE, tableSchema);
            for (ProjectItem projectItem : project.getItems().toArray(new ProjectItem[0])) {
                Module module = (Module)projectItem;
                if (module.isExcludeTable(tableSchema.getName())) continue;
                model.put(MODULE, module);
                model.put("baseNamespace", module.getFullNamespace());
                model.put("entityNamespace", module.getFullNamespace() + ".data.entity");
                model.put("conditionNamespace", module.getFullNamespace() + ".data.condition");
                model.put("converterNamespace", module.getFullNamespace() + ".data.converter");
                model.put("daoNamespace", module.getFullNamespace() + ".data.auto.dao");
                model.put("autoServiceNamespace", module.getFullNamespace() + ".data.auto.service");
                model.put("autoServiceImplNamespace", module.getFullNamespace() + ".data.auto.service.impl");
                model.put("serviceNamespace", module.getFullNamespace() + ".data.service");
                model.put("serviceImplNamespace", module.getFullNamespace() + ".data.service.impl");
                model.put("controllerNamespace", module.getFullNamespace() + ".web.auto");
                for (ITemplate template : module.getTemplateMap().values()) {
                    engine.write(globalConfig, template, model);
                }
            }
        }
    }

    public void test() {
    }
}

