/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.generate.service;

import cn.net.vidyo.framework.generate.common.GeneratorParam;
import cn.net.vidyo.framework.generate.gen.CodeFile;
import cn.net.vidyo.framework.generate.gen.GeneratorConfig;
import cn.net.vidyo.framework.generate.gen.SQLContext;
import cn.net.vidyo.framework.generate.gen.SQLService;
import cn.net.vidyo.framework.generate.gen.SQLServiceFactory;
import cn.net.vidyo.framework.generate.gen.TableDefinition;
import cn.net.vidyo.framework.generate.gen.TableSelector;
import cn.net.vidyo.framework.generate.gen.entity.TemplateConfig;
import cn.net.vidyo.framework.generate.util.FormatUtil;
import cn.net.vidyo.framework.generate.util.VelocityUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.velocity.VelocityContext;
import org.springframework.util.StringUtils;

public class GeneratorService {
    static ExecutorService executorService = Executors.newFixedThreadPool(2);
    private String formatXml = "false";

    public List<CodeFile> generate(GeneratorParam generatorParam, GeneratorConfig generatorConfig) {
        List<SQLContext> contextList = this.buildSQLContextList(generatorParam, generatorConfig);
        ArrayList<CodeFile> codeFileList = new ArrayList<CodeFile>();
        for (SQLContext sqlContext : contextList) {
            this.setPackageName(sqlContext, generatorParam.getPackageName());
            this.setDelPrefix(sqlContext, generatorParam.getDelPrefix());
            this.setAuthor(sqlContext, generatorParam.getAuthor());
            for (int tcId : generatorParam.getTemplateConfigIdList()) {
                TemplateConfig template = generatorConfig.getTemplateConfigById(tcId);
                String folder = template.getFolder();
                if (StringUtils.isEmpty((Object)folder)) {
                    folder = template.getName();
                }
                String fileName = this.doGenerator(sqlContext, template.getFileName());
                String content = this.doGenerator(sqlContext, template.getContent());
                content = this.formatCode(fileName, content);
                CodeFile codeFile = new CodeFile();
                codeFile.setFolder(folder);
                codeFile.setFileName(fileName);
                codeFile.setContent(content);
                codeFileList.add(codeFile);
            }
        }
        return codeFileList;
    }

    private String formatCode(String fileName, String content) {
        if (Objects.equals("true", this.formatXml) && fileName.endsWith(".xml")) {
            return FormatUtil.formatXml(content);
        }
        return content;
    }

    private List<SQLContext> buildSQLContextList(GeneratorParam generatorParam, GeneratorConfig generatorConfig) {
        List<String> tableNames = generatorParam.getTableNames();
        ArrayList<SQLContext> contextList = new ArrayList<SQLContext>();
        SQLService service = SQLServiceFactory.build(generatorConfig);
        TableSelector tableSelector = service.getTableSelector(generatorConfig);
        tableSelector.setSchTableNames(tableNames);
        List<TableDefinition> tableDefinitions = tableSelector.getTableDefinitions();
        for (TableDefinition tableDefinition : tableDefinitions) {
            SQLContext sqlContext = new SQLContext(tableDefinition);
            sqlContext.setDbName(generatorConfig.getDbName());
            contextList.add(sqlContext);
        }
        return contextList;
    }

    private void setPackageName(SQLContext sqlContext, String packageName) {
        if (StringUtils.hasText((String)packageName)) {
            sqlContext.setPackageName(packageName);
        }
    }

    private void setDelPrefix(SQLContext sqlContext, String delPrefix) {
        if (StringUtils.hasText((String)delPrefix)) {
            sqlContext.setDelPrefix(delPrefix);
        }
    }

    private void setAuthor(SQLContext sqlContext, String author) {
        if (StringUtils.hasText((String)author)) {
            sqlContext.setAuthor(author);
        }
    }

    private String doGenerator(SQLContext sqlContext, String template) {
        if (template == null) {
            return "";
        }
        VelocityContext context = new VelocityContext();
        Object pkColumn = sqlContext.getTableDefinition().getPkColumn();
        if (pkColumn == null) {
            pkColumn = Collections.emptyMap();
        }
        context.put("context", (Object)sqlContext);
        context.put("table", (Object)sqlContext.getTableDefinition());
        context.put("pk", pkColumn);
        context.put("columns", sqlContext.getTableDefinition().getColumnDefinitions());
        context.put("csharpColumns", sqlContext.getTableDefinition().getCsharpColumnDefinitions());
        return VelocityUtil.generate(context, template);
    }
}

