/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.generate.gen.sqlserver;

import cn.net.vidyo.framework.generate.gen.TypeFormatter;
import java.util.Arrays;
import java.util.Collections;

public class SqlServerTypeFormatter
implements TypeFormatter {
    @Override
    public boolean isBit(String columnType) {
        return this.contains(Collections.singletonList("bit"), columnType);
    }

    @Override
    public boolean isBoolean(String columnType) {
        return this.contains(Collections.singletonList("boolean"), columnType);
    }

    @Override
    public boolean isTinyint(String columnType) {
        return this.contains(Collections.singletonList("tinyint"), columnType);
    }

    @Override
    public boolean isSmallint(String columnType) {
        return this.contains(Collections.singletonList("smallint"), columnType);
    }

    @Override
    public boolean isInt(String columnType) {
        return !this.isLong(columnType) && this.contains(Arrays.asList("int", "integer"), columnType);
    }

    @Override
    public boolean isLong(String columnType) {
        return !this.isVarchar(columnType) && this.contains(Collections.singletonList("bigint"), columnType);
    }

    @Override
    public boolean isFloat(String columnType) {
        return this.contains(Arrays.asList("float", "real"), columnType);
    }

    @Override
    public boolean isDouble(String columnType) {
        return this.contains(Collections.singletonList("double"), columnType);
    }

    @Override
    public boolean isDecimal(String columnType) {
        return this.contains(Arrays.asList("decimal", "numeric", "money", "smallmoney"), columnType);
    }

    @Override
    public boolean isVarchar(String columnType) {
        return this.contains(Arrays.asList("CHAR", "VARCHAR", "TEXT", "nchar", "nvarchar", "ntext"), columnType);
    }

    @Override
    public boolean isDatetime(String columnType) {
        return this.contains(Arrays.asList("DATE", "TIME", "DATETIME", "TIMESTAMP", "datetime2", "smalldatetime", "datetimeoffset"), columnType);
    }

    @Override
    public boolean isBlob(String columnType) {
        return this.contains(Arrays.asList("blob", "binary", "varbinary"), columnType);
    }

    @Override
    public boolean isJsonb(String columnType) {
        return false;
    }
}

