/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.generate.gen.postgresql;

import cn.net.vidyo.framework.generate.gen.ColumnSelector;
import cn.net.vidyo.framework.generate.gen.GeneratorConfig;
import cn.net.vidyo.framework.generate.gen.TableDefinition;
import cn.net.vidyo.framework.generate.gen.TableSelector;
import cn.net.vidyo.framework.generate.util.FieldUtil;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class PostgreSqlTableSelector
extends TableSelector {
    private static final String DEFAULT_SCHEMA = "public";
    private static final String SHOW_TABLE_SQL = "SELECT  t.schemaname, t.tablename, t2.cmt FROM  pg_tables t LEFT JOIN   (  SELECT relname as tablename, obj_description(oid) AS cmt  FROM pg_class C  WHERE relkind='r' AND relname NOT LIKE 'pg_%%' AND relname NOT LIKE 'sql_%%' AND relchecks=0   ORDER BY relname  ) t2 ON t.tablename = t2.tablename WHERE schemaname != 'pg_catalog' AND schemaname != 'information_schema' %s %s";

    public PostgreSqlTableSelector(ColumnSelector columnSelector, GeneratorConfig generatorConfig) {
        super(columnSelector, generatorConfig);
    }

    @Override
    protected String getShowTablesSQL(GeneratorConfig generatorConfig) {
        String schema = generatorConfig.getSchemaName();
        if (schema == null) {
            schema = "";
        }
        if (StringUtils.hasText((String)schema)) {
            schema = String.format("AND schemaname = '%s'", schema);
        }
        List<String> tableNames = this.wrapTableNames();
        String and = "";
        if (!tableNames.isEmpty()) {
            and = String.format("AND t.tablename in (%s)", String.join((CharSequence)",", tableNames));
        }
        return String.format(SHOW_TABLE_SQL, schema, and);
    }

    @Override
    protected TableDefinition buildTableDefinition(Map<String, Object> tableMap) {
        TableDefinition tableDefinition = new TableDefinition();
        tableDefinition.setSchema(FieldUtil.convertString(tableMap.get("SCHEMANAME")));
        tableDefinition.setTableName(FieldUtil.convertString(tableMap.get("TABLENAME")));
        tableDefinition.setComment(FieldUtil.convertString(tableMap.get("CMT")));
        return tableDefinition;
    }
}

