/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.generate.gen.mysql;

import cn.net.vidyo.framework.generate.gen.ColumnSelector;
import cn.net.vidyo.framework.generate.gen.GeneratorConfig;
import cn.net.vidyo.framework.generate.gen.TableDefinition;
import cn.net.vidyo.framework.generate.gen.TableSelector;
import cn.net.vidyo.framework.generate.util.FieldUtil;
import java.util.Map;

public class MySqlTableSelector
extends TableSelector {
    public MySqlTableSelector(ColumnSelector columnSelector, GeneratorConfig dataBaseConfig) {
        super(columnSelector, dataBaseConfig);
    }

    @Override
    protected String getShowTablesSQL(GeneratorConfig generatorConfig) {
        String dbName = generatorConfig.getDbName();
        if (!dbName.startsWith("`") || !dbName.endsWith("`")) {
            dbName = String.format("`%s`", dbName);
        }
        String sql = "SHOW TABLE STATUS FROM " + dbName;
        if (this.getSchTableNames() != null && this.getSchTableNames().size() > 0) {
            StringBuilder tables = new StringBuilder();
            for (String table : this.getSchTableNames()) {
                tables.append(",'").append(table).append("'");
            }
            sql = sql + " WHERE NAME IN (" + tables.substring(1) + ")";
        }
        return sql;
    }

    @Override
    protected TableDefinition buildTableDefinition(Map<String, Object> tableMap) {
        TableDefinition tableDefinition = new TableDefinition();
        tableDefinition.setTableName(FieldUtil.convertString(tableMap.get("NAME")));
        tableDefinition.setComment(FieldUtil.convertString(tableMap.get("COMMENT")));
        return tableDefinition;
    }
}

