/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.generate.gen;

import cn.net.vidyo.framework.generate.gen.TypeEnum;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public interface TypeFormatter {
    default public String format(String columnType) {
        if (this.isBit(columnType)) {
            return TypeEnum.BIT.getType();
        }
        if (this.isBoolean(columnType)) {
            return TypeEnum.BOOLEAN.getType();
        }
        if (this.isTinyint(columnType)) {
            return TypeEnum.TINYINT.getType();
        }
        if (this.isSmallint(columnType)) {
            return TypeEnum.SMALLINT.getType();
        }
        if (this.isInt(columnType)) {
            return TypeEnum.INT.getType();
        }
        if (this.isLong(columnType)) {
            return TypeEnum.BIGINT.getType();
        }
        if (this.isFloat(columnType)) {
            return TypeEnum.FLOAT.getType();
        }
        if (this.isDouble(columnType)) {
            return TypeEnum.DOUBLE.getType();
        }
        if (this.isDecimal(columnType)) {
            return TypeEnum.DECIMAL.getType();
        }
        if (this.isJsonb(columnType)) {
            return TypeEnum.JSONB.getType();
        }
        if (this.isVarchar(columnType)) {
            return TypeEnum.VARCHAR.getType();
        }
        if (this.isDatetime(columnType)) {
            return TypeEnum.DATETIME.getType();
        }
        if (this.isBlob(columnType)) {
            return TypeEnum.BLOB.getType();
        }
        return TypeEnum.VARCHAR.getType();
    }

    default public boolean contains(List<String> columnTypes, String type) {
        for (String columnType : columnTypes) {
            if (!StringUtils.containsIgnoreCase((String)type, (String)columnType)) continue;
            return true;
        }
        return false;
    }

    public boolean isBit(String var1);

    public boolean isBoolean(String var1);

    public boolean isTinyint(String var1);

    public boolean isSmallint(String var1);

    public boolean isInt(String var1);

    public boolean isLong(String var1);

    public boolean isFloat(String var1);

    public boolean isDouble(String var1);

    public boolean isDecimal(String var1);

    public boolean isVarchar(String var1);

    public boolean isDatetime(String var1);

    public boolean isBlob(String var1);

    public boolean isJsonb(String var1);
}

