/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.generate.gen;

import cn.net.vidyo.framework.generate.gen.DataSourceManager;
import cn.net.vidyo.framework.generate.gen.GeneratorConfig;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.pooled.PooledDataSourceFactory;
import org.apache.ibatis.jdbc.SqlRunner;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.scripting.xmltags.TextSqlNode;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlHelper {
    private static final Logger logger = LoggerFactory.getLogger(SqlHelper.class);
    private static final String DRIVER = "driver";
    private static final String URL = "url";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final Map<String, DataSource> dataSourceMap = new ConcurrentHashMap<String, DataSource>(16);
    private static final ThreadLocal<Connection> connectionLocal = new ThreadLocal();

    public static List<Map<String, Object>> runSql(GeneratorConfig generatorConfig, String sql, Map<String, Object> params) {
        DataSource dataSource = DataSourceManager.getDataSource(generatorConfig);
        String runSql = SqlHelper.buildSqlWithParams(dataSource, sql, params);
        String[] sqls = runSql.split(";");
        Connection conn = null;
        try {
            conn = DataSourceManager.getConnection(generatorConfig);
            SqlRunner runner = SqlHelper.buildSqlRunner(conn);
            int sqlCount = sqls.length;
            if (sqlCount == 1) {
                return runner.selectAll(sqls[0], new Object[0]);
            }
            for (int i = 0; i < sqlCount - 1; ++i) {
                runner.run(sqls[i]);
            }
            return runner.selectAll(sqls[sqlCount - 1], new Object[0]);
        }
        catch (SQLException e1) {
            logger.error("\u751f\u6210\u4ee3\u7801\u9519\u8bef", (Throwable)e1);
            throw new RuntimeException("\u751f\u6210\u4ee3\u7801\u9519\u8bef");
        }
    }

    public static Connection getConnection(GeneratorConfig generatorConfig) {
        Connection connection = connectionLocal.get();
        if (connection == null) {
            try {
                connection = SqlHelper.getDataSource(generatorConfig).getConnection();
                connectionLocal.set(connection);
            }
            catch (SQLException e) {
                logger.error("\u83b7\u53d6Connection\u5931\u8d25, jdbcUrl:{}", (Object)generatorConfig.getJdbcUrl(), (Object)e);
                throw new RuntimeException("\u83b7\u53d6Connection\u5931\u8d25", e);
            }
        }
        return connection;
    }

    public static void closeConnection() {
        Connection connection = connectionLocal.get();
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        connectionLocal.remove();
    }

    private static String buildSqlWithParams(DataSource dataSource, String sql, Map<String, Object> params) {
        Configuration configuration = SqlHelper.buildConfiguration(dataSource);
        TextSqlNode node = new TextSqlNode(sql);
        DynamicSqlSource dynamicSqlSource = new DynamicSqlSource(configuration, (SqlNode)node);
        BoundSql boundSql = dynamicSqlSource.getBoundSql(params);
        return boundSql.getSql();
    }

    public static List<Map<String, Object>> runSql(GeneratorConfig dataBaseConfig, String sql) {
        return SqlHelper.runSql(dataBaseConfig, sql, null);
    }

    private static SqlRunner buildSqlRunner(Connection connection) {
        return new SqlRunner(connection);
    }

    private static DataSource getDataSource(GeneratorConfig generatorConfig) {
        String jdbcUrl = generatorConfig.getJdbcUrl();
        return dataSourceMap.computeIfAbsent(jdbcUrl, key -> {
            Properties properties = new Properties();
            properties.setProperty(DRIVER, generatorConfig.getDriverClass());
            properties.setProperty(URL, jdbcUrl);
            properties.setProperty(USERNAME, generatorConfig.getUsername());
            properties.setProperty(PASSWORD, generatorConfig.getPassword());
            PooledDataSourceFactory pooledDataSourceFactory = new PooledDataSourceFactory();
            pooledDataSourceFactory.setProperties(properties);
            return pooledDataSourceFactory.getDataSource();
        });
    }

    private static Configuration buildConfiguration(DataSource dataSource) {
        JdbcTransactionFactory transactionFactory = new JdbcTransactionFactory();
        Environment environment = new Environment("development", (TransactionFactory)transactionFactory, dataSource);
        return new Configuration(environment);
    }
}

