/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.generate.gen;

import cn.net.vidyo.framework.generate.gen.DbType;
import cn.net.vidyo.framework.generate.gen.GeneratorConfig;
import cn.net.vidyo.framework.generate.gen.SQLService;
import cn.net.vidyo.framework.generate.gen.mysql.MySqlService;
import cn.net.vidyo.framework.generate.gen.oracle.OracleService;
import cn.net.vidyo.framework.generate.gen.postgresql.PostgreSqlService;
import cn.net.vidyo.framework.generate.gen.sqlserver.SqlServerService;
import java.util.HashMap;
import java.util.Map;

public class SQLServiceFactory {
    private static final Map<Integer, SQLService> SERVICE_CONFIG = new HashMap<Integer, SQLService>(16);

    public static SQLService build(GeneratorConfig generatorConfig) {
        SQLService service = SERVICE_CONFIG.get(generatorConfig.getDbType());
        if (service == null) {
            throw new RuntimeException("\u672c\u7cfb\u7edf\u6682\u4e0d\u652f\u6301\u8be5\u6570\u636e\u6e90(" + generatorConfig.getDriverClass() + ")");
        }
        return service;
    }

    static {
        SERVICE_CONFIG.put(DbType.MYSQL.getType(), new MySqlService());
        SERVICE_CONFIG.put(DbType.ORACLE.getType(), new OracleService());
        SERVICE_CONFIG.put(DbType.SQL_SERVER.getType(), new SqlServerService());
        SERVICE_CONFIG.put(DbType.POSTGRE_SQL.getType(), new PostgreSqlService());
    }
}

