/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.generate.gen;

import cn.net.vidyo.framework.generate.common.IdWorker;
import cn.net.vidyo.framework.generate.gen.JavaColumnDefinition;
import cn.net.vidyo.framework.generate.gen.TableDefinition;
import cn.net.vidyo.framework.generate.util.FieldUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;

public class SQLContext {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    private final LocalDateTime localDateTime = LocalDateTime.now();
    private final TableDefinition tableDefinition;
    private final JavaColumnDefinition javaPkColumn;
    private String packageName;
    private String delPrefix;
    private String dbName;
    private String author;

    public SQLContext(TableDefinition tableDefinition) {
        this.tableDefinition = tableDefinition;
        this.packageName = this.getJavaBeanName().toLowerCase();
        this.javaPkColumn = (JavaColumnDefinition)this.tableDefinition.getPkColumn();
    }

    public String getDatetime() {
        return this.localDateTime.format(DATE_TIME_FORMATTER);
    }

    public String getDate() {
        return this.localDateTime.format(DATE_FORMATTER);
    }

    public String getTime() {
        return this.localDateTime.format(TIME_FORMATTER);
    }

    public int getRandomInt() {
        return RandomUtils.nextInt((int)Integer.MAX_VALUE);
    }

    public long getRandomLong() {
        return RandomUtils.nextLong();
    }

    public boolean getRandomBoolean() {
        return RandomUtils.nextBoolean();
    }

    public String getUuid() {
        return UUID.randomUUID().toString();
    }

    public long getNextId() {
        return IdWorker.getInstance().nextId();
    }

    public String getJavaBeanName() {
        return this.getClassName();
    }

    public String getClassName() {
        String tableName = this.getJavaBeanNameLF();
        return FieldUtil.upperFirstLetter(tableName);
    }

    public String getJavaBeanNameLF() {
        String tableName = this.tableDefinition.getTableName();
        if (this.delPrefix != null) {
            String[] split;
            for (String prefix : split = this.delPrefix.split("\\s*,\\s*")) {
                tableName = StringUtils.removeStart((String)tableName, (String)prefix);
            }
        }
        tableName = FieldUtil.underlineFilter(tableName);
        tableName = FieldUtil.dotFilter(tableName);
        return FieldUtil.lowerFirstLetter(tableName);
    }

    public String getPkName() {
        if (this.javaPkColumn != null) {
            return this.javaPkColumn.getColumnName();
        }
        return "";
    }

    public String getJavaPkName() {
        if (this.javaPkColumn != null) {
            return this.javaPkColumn.getJavaFieldName();
        }
        return "";
    }

    public String getJavaPkType() {
        if (this.javaPkColumn != null) {
            return this.javaPkColumn.getJavaType();
        }
        return "";
    }

    public String getMybatisPkType() {
        if (this.javaPkColumn != null) {
            return this.javaPkColumn.getMybatisJdbcType();
        }
        return "";
    }

    public TableDefinition getTableDefinition() {
        return this.tableDefinition;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getDelPrefix() {
        return this.delPrefix;
    }

    public void setDelPrefix(String delPrefix) {
        this.delPrefix = delPrefix;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }
}

