/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder.query;

import cn.net.vidyo.framework.builder.domain.JdbcType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseMetaDataWrapper {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseMetaDataWrapper.class);
    private final DatabaseMetaData databaseMetaData;
    private final String catalog;
    private final String schema;

    public DatabaseMetaDataWrapper(Connection connection) {
        try {
            this.databaseMetaData = connection.getMetaData();
            this.catalog = connection.getCatalog();
            this.schema = connection.getSchema();
        }
        catch (SQLException e) {
            throw new RuntimeException("\u83b7\u53d6\u5143\u6570\u636e\u9519\u8bef:", e);
        }
    }

    public Map<String, ColumnsInfo> getColumnsInfo(String tableNamePattern) throws SQLException {
        return this.getColumnsInfo(this.catalog, this.schema, tableNamePattern);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, ColumnsInfo> getColumnsInfo(String catalog, String schema, String tableName) throws SQLException {
        HashSet<String> primaryKeys = new HashSet<String>();
        try (ResultSet primaryKeysResultSet = this.databaseMetaData.getPrimaryKeys(catalog, schema, tableName);){
            while (primaryKeysResultSet.next()) {
                String columnName = primaryKeysResultSet.getString("COLUMN_NAME");
                primaryKeys.add(columnName);
            }
            if (primaryKeys.size() > 1) {
                logger.warn("\u5f53\u524d\u8868:{}\uff0c\u5b58\u5728\u591a\u4e3b\u952e\u60c5\u51b5\uff01", (Object)tableName);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("\u8bfb\u53d6\u8868\u4e3b\u952e\u4fe1\u606f:" + tableName + "\u9519\u8bef:", e);
        }
        HashMap<String, ColumnsInfo> columnsInfoMap = new HashMap<String, ColumnsInfo>();
        try (ResultSet resultSet = this.databaseMetaData.getColumns(catalog, schema, tableName, "%");){
            while (resultSet.next()) {
                ColumnsInfo columnsInfo = new ColumnsInfo();
                String name = resultSet.getString("COLUMN_NAME");
                columnsInfo.name = name;
                columnsInfo.primaryKey = primaryKeys.contains(name);
                columnsInfo.jdbcType = JdbcType.forCode(resultSet.getInt("DATA_TYPE"));
                columnsInfo.length = resultSet.getInt("COLUMN_SIZE");
                columnsInfo.scale = resultSet.getInt("DECIMAL_DIGITS");
                columnsInfo.remarks = this.formatComment(resultSet.getString("REMARKS"));
                columnsInfo.defaultValue = resultSet.getString("COLUMN_DEF");
                columnsInfo.nullable = resultSet.getInt("NULLABLE") == 1;
                columnsInfo.autoIncrement = "YES".equals(resultSet.getString("IS_AUTOINCREMENT"));
                columnsInfoMap.put(name.toLowerCase(), columnsInfo);
            }
            Map<String, ColumnsInfo> map = Collections.unmodifiableMap(columnsInfoMap);
            return map;
        }
        catch (SQLException e) {
            throw new RuntimeException("\u8bfb\u53d6\u8868\u5b57\u6bb5\u4fe1\u606f:" + tableName + "\u9519\u8bef:", e);
        }
    }

    public String formatComment(String comment) {
        return StringUtils.isBlank((CharSequence)comment) ? "" : comment.replaceAll("\r\n", "\t");
    }

    public Table getTableInfo(String tableName) {
        return this.getTableInfo(this.catalog, this.schema, tableName);
    }

    public Table getTableInfo(String catalog, String schema, String tableName) {
        Table table = new Table();
        try (ResultSet resultSet = this.databaseMetaData.getTables(catalog, schema, tableName, new String[]{"TABLE", "VIEW"});){
            table.name = tableName;
            while (resultSet.next()) {
                table.remarks = this.formatComment(resultSet.getString("REMARKS"));
                table.tableType = resultSet.getString("TABLE_TYPE");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("\u8bfb\u53d6\u8868\u4fe1\u606f:" + tableName + "\u9519\u8bef:", e);
        }
        return table;
    }

    public static class ColumnsInfo {
        private boolean primaryKey;
        private boolean autoIncrement;
        private String name;
        private int length;
        private boolean nullable;
        private String remarks;
        private String defaultValue;
        private int scale;
        private JdbcType jdbcType;

        public String getName() {
            return this.name;
        }

        public int getLength() {
            return this.length;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public String getRemarks() {
            return this.remarks;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public int getScale() {
            return this.scale;
        }

        public JdbcType getJdbcType() {
            return this.jdbcType;
        }

        public boolean isPrimaryKey() {
            return this.primaryKey;
        }

        public boolean isAutoIncrement() {
            return this.autoIncrement;
        }
    }

    public static class Table {
        private String name;
        private String remarks;
        private String tableType;

        public String getRemarks() {
            return this.remarks;
        }

        public String getTableType() {
            return this.tableType;
        }

        public String getName() {
            return this.name;
        }

        public boolean isView() {
            return "VIEW".equals(this.tableType);
        }
    }
}

