/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder.query;

import cn.net.vidyo.framework.builder.config.DataSourceConfig;
import cn.net.vidyo.framework.builder.domain.CusumExecuter;
import cn.net.vidyo.framework.builder.domain.DbType;
import cn.net.vidyo.framework.builder.domain.IDbQuery;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectManager {
    protected final Logger logger = LoggerFactory.getLogger(DataSourceConfig.class);
    DataSourceConfig dataSourceConfig;
    private DataSource dataSource;
    Connection connection;
    private String schemaName;

    public ConnectManager(DataSourceConfig dataSourceConfig) {
        this.dataSourceConfig = dataSourceConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConn() {
        try {
            String schema;
            if (this.connection != null && !this.connection.isClosed()) {
                return this.connection;
            }
            ConnectManager connectManager = this;
            synchronized (connectManager) {
                this.connection = this.dataSource != null ? this.dataSource.getConnection() : DriverManager.getConnection(this.dataSourceConfig.getUrl(), this.dataSourceConfig.getUsername(), this.dataSourceConfig.getPassword());
            }
            String string = schema = StringUtils.isNotBlank((CharSequence)this.dataSourceConfig.getSchemaName()) ? this.dataSourceConfig.getSchemaName() : this.getDefaultSchema(this.dataSourceConfig.getDbType(), this.dataSourceConfig.getUsername());
            if (StringUtils.isNotBlank((CharSequence)schema)) {
                this.schemaName = schema;
                try {
                    this.connection.setSchema(this.schemaName);
                }
                catch (Throwable t) {
                    this.logger.error("There may be exceptions in the driver and version of the database, " + t.getMessage());
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return this.connection;
    }

    protected String getDefaultSchema(DbType dbType, String username) {
        String schema = null;
        if (DbType.POSTGRE_SQL == dbType) {
            schema = "public";
        } else if (DbType.KINGBASE_ES == dbType) {
            schema = "PUBLIC";
        } else if (DbType.DB2 == dbType) {
            schema = "current schema";
        } else if (DbType.ORACLE == dbType) {
            schema = username.toUpperCase();
        }
        return schema;
    }

    public void execute2(String sql, CusumExecuter consumer) throws SQLException {
        this.logger.debug("\u6267\u884cSQL:{}", (Object)sql);
        int count = 0;
        long start = System.nanoTime();
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(sql);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                consumer.accept(consumer.createInstance(resultSet, this.dataSourceConfig.getDbQuery(), this.dataSourceConfig.getDbType()));
                ++count;
            }
            long end = System.nanoTime();
            this.logger.debug("\u8fd4\u56de\u8bb0\u5f55\u6570:{},\u8017\u65f6(ms):{}", (Object)count, (Object)((end - start) / 1000000L));
        }
    }

    public void execute(String sql, final Consumer<ResultSetWrapper> consumer) throws SQLException {
        this.execute2(sql, new CusumExecuter<ResultSetWrapper>(){

            @Override
            public ResultSetWrapper createInstance(ResultSet resultSet, IDbQuery dbQuery, DbType dbType) {
                return new ResultSetWrapper(resultSet, dbQuery, dbType);
            }

            @Override
            public void accept(ResultSetWrapper o) {
                consumer.accept(o);
            }
        });
    }

    public Connection getConnection() {
        if (this.connection == null) {
            this.connection = this.getConn();
        }
        return this.connection;
    }

    public void closeConnection() {
        Optional.ofNullable(this.connection).ifPresent(con -> {
            try {
                con.close();
            }
            catch (SQLException sqlException) {
                sqlException.printStackTrace();
            }
        });
    }

    public static class ResultSetWrapper {
        private final IDbQuery dbQuery;
        private final ResultSet resultSet;
        private final DbType dbType;

        ResultSetWrapper(ResultSet resultSet, IDbQuery dbQuery, DbType dbType) {
            this.resultSet = resultSet;
            this.dbQuery = dbQuery;
            this.dbType = dbType;
        }

        public ResultSet getResultSet() {
            return this.resultSet;
        }

        public String getStringResult(String columnLabel) {
            try {
                return this.resultSet.getString(columnLabel);
            }
            catch (SQLException sqlException) {
                throw new RuntimeException(String.format("\u8bfb\u53d6[%s]\u5b57\u6bb5\u51fa\u9519!", columnLabel), sqlException);
            }
        }

        public String getFiledComment() {
            return this.getComment(this.dbQuery.fieldComment());
        }

        @Deprecated
        private String getComment(String columnLabel) {
            return StringUtils.isNotBlank((CharSequence)columnLabel) ? this.formatComment(this.getStringResult(columnLabel)) : "";
        }

        @Deprecated
        public String getTableComment() {
            return this.getComment(this.dbQuery.tableComment());
        }

        @Deprecated
        public String formatComment(String comment) {
            return StringUtils.isBlank((CharSequence)comment) ? "" : comment.replaceAll("\r\n", "\t");
        }

        @Deprecated
        public boolean isPrimaryKey() {
            String key = this.getStringResult(this.dbQuery.fieldKey());
            if (DbType.DB2 == this.dbType || DbType.SQLITE == this.dbType || DbType.CLICK_HOUSE == this.dbType) {
                return StringUtils.isNotBlank((CharSequence)key) && "1".equals(key);
            }
            return StringUtils.isNotBlank((CharSequence)key) && "PRI".equalsIgnoreCase(key);
        }
    }
}

