/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder.converts;

import cn.net.vidyo.framework.builder.converts.MySqlTypeConvert;
import cn.net.vidyo.framework.builder.converts.select.BranchBuilder;
import cn.net.vidyo.framework.builder.converts.select.Selector;
import cn.net.vidyo.framework.builder.domain.DbType;
import cn.net.vidyo.framework.builder.domain.IColumnType;
import cn.net.vidyo.framework.builder.domain.ITypeConvert;

public class TypeConverts {
    public static ITypeConvert getTypeConvert(DbType dbType) {
        switch (dbType) {
            case MYSQL: 
            case MARIADB: {
                return MySqlTypeConvert.INSTANCE;
            }
        }
        return null;
    }

    static Selector<String, IColumnType> use(String param) {
        return new Selector<String, IColumnType>(param.toLowerCase());
    }

    static BranchBuilder<String, IColumnType> contains(CharSequence value) {
        return BranchBuilder.of(s -> s.contains(value));
    }

    static BranchBuilder<String, IColumnType> containsAny(CharSequence ... values) {
        return BranchBuilder.of(s -> {
            for (CharSequence value : values) {
                if (!s.contains(value)) continue;
                return true;
            }
            return false;
        });
    }
}

