/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder.config;

import cn.net.vidyo.framework.builder.config.Module;
import cn.net.vidyo.framework.builder.config.ProjectItem;
import cn.net.vidyo.framework.builder.domain.DateType;
import java.io.File;

public class Project
extends ProjectItem {
    private DateType dateType = DateType.TIME_PACK;

    Module addRootModule() {
        Module module = new Module();
        module.setName("root");
        module.setComment("root");
        module.setOutpath("");
        module.setNamespace("");
        module.setOverrideModel(this.overrideModel);
        this.addModule(module);
        return module;
    }

    public Module getRootModule() {
        return this.getModule("root");
    }

    public Project addDefaultTemplate() {
        Module rootModule = this.getRootModule();
        if (rootModule == null) {
            rootModule = this.addRootModule();
        }
        rootModule.addDefaultTemplate();
        return this;
    }

    public Project addModule(Module ... modules) {
        for (Module module : modules) {
            if (module.getNamespace().length() > 0) {
                module.setFullNamespace(this.namespace + "." + module.getNamespace());
            } else {
                module.setFullNamespace(this.namespace);
            }
            if (module.getOutpath().length() > 0) {
                module.setFullOutpath(this.getOutpath() + File.separator + module.getOutpath());
                continue;
            }
            module.setFullOutpath(this.getOutpath());
        }
        this.addItem(modules);
        return this;
    }

    public Module getModule(String name) {
        ProjectItem item = this.getItem(name);
        return (Module)item;
    }

    public Module getModuleByTableName(String tableName) {
        for (ProjectItem item : this.items) {
            Module module = (Module)item;
            if (!module.containsByTableName(this.name)) continue;
            return module;
        }
        return null;
    }

    public Project addTableName(String moduleName, String ... tableNames) {
        Module module = this.getModule(moduleName);
        if (module == null) {
            module = new Module();
            module.setName(moduleName);
            module.setComment(moduleName);
            module.setOutpath(moduleName);
            module.setNamespace(moduleName);
            module.setOverrideModel(this.overrideModel);
            this.addItem(module);
        }
        module.addTableName(tableNames);
        return this;
    }

    public DateType getDateType() {
        return this.dateType;
    }

    public void setDateType(DateType dateType) {
        this.dateType = dateType;
    }
}

