package cn.net.vidyo.framework.builder.meta;

import cn.net.vidyo.framework.builder.domain.DbColumnType;
import cn.net.vidyo.framework.common.util.ValueUtil;

import java.util.ArrayList;
import java.util.List;
public class TableSchema {
    String schemaName="";
    String name ="";
    String comment ="";
    List<ColumnSchema> columns=new ArrayList<>();
    List<String> excludeColumns=new ArrayList<>();
    ColumnSchema IdColumn=null;

    public TableSchema() {
        excludeColumns.add("id");
        excludeColumns.add("hidden");
        excludeColumns.add("createtime");
        excludeColumns.add("updatetime");
    }

    public List<ColumnSchema> getIncludeColumns(){
        List<ColumnSchema> list = new ArrayList<>();
        for (ColumnSchema column : columns) {
            if(!excludeColumns.contains(column.getName().toLowerCase())){
                list.add(column);
            }
        }
        return list;
    }

    public void addColumn(ColumnSchema columnSchema){
        columns.add(columnSchema);
        if(columnSchema.getName()=="id"){
            IdColumn=columnSchema;
        }
    }
    public String getFirstLetterName(){
        return ValueUtil.firstLetterName(name);
    }

    public String getBaseClassString(){
        DbColumnType columnType = (DbColumnType) (getIdColumn().getColumnType());
       if(columnType==DbColumnType.STRING){
           return "StringModel";
       }
        if(columnType==DbColumnType.BIG_INTEGER || columnType==DbColumnType.LONG){
            return "AutoLongModel";
        }
        if(columnType==DbColumnType.INTEGER){
            return "AutoIntModel";
        }
        if(columnType==null){
            System.out.println("columnType is null");
        }else{
            System.out.println("columnType is " + columnType);
        }

        return "";
    }
    public String getKeyClassString(){
        DbColumnType columnType = (DbColumnType) (getIdColumn().getColumnType());
        if(columnType==DbColumnType.STRING){
            return "String";
        }
        if(columnType==DbColumnType.BIG_INTEGER || columnType==DbColumnType.LONG){
            return "Long";
        }
        if(columnType==DbColumnType.INTEGER){
            return "Integer";
        }
        if(columnType==null){
            System.out.println("columnType is null");
        }else{
            System.out.println("columnType is " + columnType);
        }

        return "";
    }

    public String getSchemaName() {
        return schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<ColumnSchema> getColumns() {
        return columns;
    }

    public void setColumns(List<ColumnSchema> columns) {
        this.columns = columns;
    }

    public List<String> getExcludeColumns() {
        return excludeColumns;
    }

    public void setExcludeColumns(List<String> excludeColumns) {
        this.excludeColumns = excludeColumns;
    }

    public ColumnSchema getIdColumn() {
        return IdColumn;
    }

    public void setIdColumn(ColumnSchema idColumn) {
        IdColumn = idColumn;
    }
}
