package cn.net.vidyo.framework.builder.engine;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.Locale;

public class FreemakerTemplateEngine extends AbstractTemplateEngine{
    Configuration conf;
    @Override
    public void init() {
        //1.定义Configuration对象
        conf = new Configuration(Configuration.VERSION_2_3_26);
        conf.setEncoding(Locale.getDefault(), "UTF-8");
        //2.设置模板加载器
//        conf.setClassForTemplateLoading(ctx, ftlPath);
        TemplateLoader templateLoader=new ClassTemplateLoader(FreemakerTemplateEngine.class,"/");
        conf.setTemplateLoader(templateLoader);
    }

    @Override
    public boolean write(String templatePath, String outFilePath, Object model) {
        try {
            //3.根据模板名称获取模板对象Template
            Template template = conf.getTemplate(templatePath);
            FileOutputStream fos = null;
            fos = new FileOutputStream(outFilePath);
            OutputStreamWriter osw = new OutputStreamWriter(fos,"UTF8");
            template.process(model, osw);
            fos.close();
            return true;
        } catch (Exception e) {
            e.printStackTrace();
        }

        return false;
    }
}
