package cn.net.vidyo.faker;

/**
 * User: 马生录（mason
 * Date: 13-7-16
 * Time: 上午9:31
 */
public class FakerPhone extends AbstractFaker {
    public static final String MOBILE = "MOBILE";
    public static final String TELPHONE = "TELPHONE";
    public static final String EN_MOBILE = "EN_MOBILE";
    public static final String EN_TELPHONE = "EN_TELPHONE";

    static FakerPhone instance = new FakerPhone();

    @Override
    protected String getKeyName(String key) {
        if (key.equals(MOBILE)) {
            return "cn_mobile.txt";
        }
        if (key.equals(TELPHONE)) {
            return "cn_telphone.txt";
        }
        if (key.equals(EN_MOBILE)) {
            return "en_mobile.txt";
        }
        if (key.equals(EN_TELPHONE)) {
            return "en_telphone.txt";
        }
        return super.getKeyName(key);
    }

    public static String tel() {
        return instance.pick(TELPHONE);
    }

    public static String tel(int len) {
        return instance.pick(TELPHONE, len);
    }

    public static String mobile() {
        return instance.pick(MOBILE);
    }

    public static String mobile(int len) {
        return instance.pick(MOBILE, len);
    }

    public static String enTel() {
        return instance.pick(EN_TELPHONE);
    }

    public static String enTel(int len) {
        return instance.pick(EN_TELPHONE, len);
    }

    public static String enMobile() {
        return instance.pick(EN_MOBILE);
    }

    public static String enMobile(int len) {
        return instance.pick(EN_MOBILE, len);
    }
}
