package cn.net.vidyo.faker;

import java.util.*;

/**
 * User: 马生录（mason
 * Date: 13-7-16
 * Time: 上午9:31
 */
public class FakerNumber extends AbstractFaker {
    protected static Random random = new Random((new Date().getTime()));

    //<editor-fold desc="toLoop">
    public static int toLoopInt(Set<Integer> items) {
        return toLoopInt(Integer.MAX_VALUE,items);
    }

    public static int toLoopInt(int max,Set<Integer> items) {
        return toLoopInt(max,items,Integer.MAX_VALUE);
    }
    public static int toLoopInt(int max,Set<Integer> items,int loopMax) {
        return toLoopInt(1,max,items,Integer.MAX_VALUE);
    }

    public static int toLoopInt(int min, int max,Set<Integer> items,int loopMax) {
        if (min >= max) return 0;
        int index=0;
        while (index<loopMax){
            int value =toInt(min, max);
            if(!items.contains(value)){
                return value;
            }
        }
        return 0;
    }

    //</editor-fold>
    //<editor-fold desc="to">
    public static int toInt() {
        return random.nextInt();
    }

    public static int toInt(int max) {
        return random.nextInt(max);
    }

    public static int toInt(int min, int max) {
        if (min >= max) return 0;
        int len = max - min;
        return random.nextInt(len) + min;
    }

    public static boolean toBoolean() {
        return random.nextBoolean();
    }

    public static double toDouble() {
        return random.nextDouble();
    }

    public static float toFloat() {
        return random.nextFloat();
    }

    public static long toLong() {
        return random.nextLong();
    }

    public static double toGaussian() {
        return random.nextGaussian();
    }

    //</editor-fold>
    //<editor-fold desc="Multi set">
    public static Set<Integer> toSetInt(int amount) {
        Set<Integer> ret = new HashSet<Integer>(amount);
        for (int i = 0; i < amount; i++) {
            ret.add(toInt());
        }
        return ret;
    }

    public static Set<Integer> toSetInt(int max, int amount) {
        Set<Integer> ret = new HashSet<Integer>(amount);
        for (int i = 0; i < amount; i++) {
            ret.add(toInt(max));
        }
        return ret;
    }

    public static Set<Integer> toSetInt(int min, int max, int amount) {
        Set<Integer> ret = new HashSet<Integer>(amount);
        for (int i = 0; i < amount; i++) {
            ret.add(toInt(min, max));
        }
        return ret;
    }

    public static Set<Boolean> toSetBoolean(int amount) {
        Set<Boolean> ret = new HashSet<Boolean>(amount);
        for (int i = 0; i < amount; i++) {
            ret.add(toBoolean());
        }
        return ret;
    }

    public static Set<Double> toSetDouble(int amount) {
        Set<Double> ret = new HashSet<Double>(amount);
        for (int i = 0; i < amount; i++) {
            ret.add(toDouble());
        }
        return ret;
    }

    public static Set<Float> toSetFloat(int amount) {
        Set<Float> ret = new HashSet<Float>(amount);
        for (int i = 0; i < amount; i++) {
            ret.add(toFloat());
        }
        return ret;
    }

    public static Set<Long> toSetLong(int amount) {
        Set<Long> ret = new HashSet<Long>(amount);
        for (int i = 0; i < amount; i++) {
            ret.add(toLong());
        }
        return ret;
    }

    public static Set<Double> toSetGaussian(int amount) {
        Set<Double> ret = new HashSet<Double>(amount);
        for (int i = 0; i < amount; i++) {
            ret.add(toGaussian());
        }
        return ret;
    }

    //</editor-fold>
    //<editor-fold desc="Multi list">
    public static List<Integer> toListInt(int amount) {
        List<Integer> ret = new ArrayList<Integer>(amount);
        for (int i = 0; i < amount; i++) {
            ret.add(toInt());
        }
        return ret;
    }

    public static List<Integer> toListInt(int max, int amount) {
        List<Integer> ret = new ArrayList<Integer>(amount);
        for (int i = 0; i < amount; i++) {
            ret.add(toInt(max));
        }
        return ret;
    }

    public static List<Integer> toListInt(int min, int max, int amount) {
        List<Integer> ret = new ArrayList<Integer>(amount);
        for (int i = 0; i < amount; i++) {
            ret.add(toInt(min, max));
        }
        return ret;
    }

    public static List<Boolean> toListBoolean(int amount) {
        List<Boolean> ret = new ArrayList<Boolean>(amount);
        for (int i = 0; i < amount; i++) {
            ret.add(toBoolean());
        }
        return ret;
    }

    public static List<Double> toListDouble(int amount) {
        List<Double> ret = new ArrayList<Double>(amount);
        for (int i = 0; i < amount; i++) {
            ret.add(toDouble());
        }
        return ret;
    }

    public static List<Float> toListFloat(int amount) {
        List<Float> ret = new ArrayList<Float>(amount);
        for (int i = 0; i < amount; i++) {
            ret.add(toFloat());
        }
        return ret;
    }

    public static List<Long> toListLong(int amount) {
        List<Long> ret = new ArrayList<Long>(amount);
        for (int i = 0; i < amount; i++) {
            ret.add(toLong());
        }
        return ret;
    }

    public static List<Double> toListGaussian(int amount) {
        List<Double> ret = new ArrayList<Double>(amount);
        for (int i = 0; i < amount; i++) {
            ret.add(toGaussian());
        }
        return ret;
    }
    //</editor-fold>

    //<editor-fold desc="Multi guarantee list">
    public static List<Integer> toGuaranteeListInt(int amount) {
        return toGuaranteeListInt(1, Integer.MAX_VALUE);
    }

    public static List<Integer> toGuaranteeListInt(int max, int amount) {
        return toGuaranteeListInt(1, max, amount);
    }

    public static List<Integer> toGuaranteeListInt(int min, int max, int amount) {
        return toGuaranteeListInt(min, max, amount,Integer.MAX_VALUE);
    }
        public static List<Integer> toGuaranteeListInt(int min, int max, int amount,int loopMax) {
        List<Integer> ret = new ArrayList<Integer>(amount);
        if (min >= max) return ret;
        int index=0;
        while (index<loopMax){
            int value =toInt(min, max);
            if(!ret.contains(value)){
                ret.add(value);
                if(ret.size()==amount){
                    return ret;
                }
            }
        }
        return ret;
    }

    //</editor-fold>
}
