package cn.net.vidyo.faker;

import java.util.ArrayList;
import java.util.List;

/**
 * User: 马生录（mason
 * Date: 13-9-29
 * Time: 上午9:53
 */
public class FakerEnum {

    public static <ENUM> List<ENUM> getAll(Class<ENUM> enumClass, int count) {
        ENUM[] enumConstants = enumClass.getEnumConstants();
        List<ENUM> list = new ArrayList<ENUM>();
        for (ENUM enumConstant : enumConstants) {
            list.add(enumConstant);
        }
        return list;
    }

    public static <ENUM> ENUM pick(Class<ENUM> entityClass) {
        List<ENUM> enums = pick(entityClass, 1);
        return enums.get(0);
    }

    public static <ENUM> List<ENUM> pick(Class<ENUM> enumClass, int count) {
        ENUM[] enumConstants = enumClass.getEnumConstants();
        if (enumConstants.length < count) {
            count = enumConstants.length;
        }
        List<Integer> ids = FakerNumber.toListInt(0,count-1,count);
        List<ENUM> enums = new ArrayList<ENUM>();
        for (Integer id : ids) {
            enums.add(enumConstants[id]);
        }
        return enums;
    }

    public static <ENUM extends Enum<ENUM>> ENUM valueOf(Class<ENUM> entityClass, String name) {
        return (ENUM)Enum.valueOf(entityClass, name);
    }

}
