package cn.net.vidyo.faker;

/**
 * User: 马生录（mason
 * Date: 13-7-16
 * Time: 上午9:30
 */
public class FakerAddress extends AbstractFaker {
    public static final String CN_ADDRESS = "CN_ADDRESS";
    public static final String EN_ADDRESS = "EN_ADDRESS";
    public static final String CN_COUNTRYCODE = "CN_COUNTRYCODE";
    public static final String CN_COUNTRY = "CN_COUNTRY";
    public static final String CN_CITY = "CN_CITY";
    public static final String CN_REGIONCODE = "CN_REGIONCODE";
    public static final String CN_REGION = "CN_REGION";
    public static final String EN_COUNTRYCODE = "EN_COUNTRYCODE";
    public static final String EN_COUNTRY = "EN_COUNTRY";
    public static final String EN_CITY = "EN_CITY";
    public static final String EN_REGIONCODE = "EN_REGIONCODE";
    public static final String EN_REGION = "EN_REGION";

    static FakerAddress instance = new FakerAddress();


    @Override
    protected String getKeyName(String key) {
        if (key.equals(CN_ADDRESS)) {
            return "cn_address.txt";
        }
        if (key.equals(EN_ADDRESS)) {
            return "en_address.txt";
        }
        if (key.equals(CN_CITY)) {
            return "cn_city.txt";
        }
        return super.getKeyName(key);
    }
    public static String city() {
        return instance.pick(CN_CITY);
    }

    public static String address() {
        return instance.pick(CN_ADDRESS);
    }

    public static String address(int len) {
        return instance.pick(CN_ADDRESS, len);
    }

    public static String enAddress() {
        return instance.pick(EN_ADDRESS);
    }

    public static String enAddress(int len) {
        return instance.pick(EN_ADDRESS, len);
    }
}

