/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.faker;

import cn.net.vidyo.faker.AbstractFaker;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FakerDateTime
extends AbstractFaker {
    public static final String COMPAT_DATE = "yyyyMMdd";
    public static final String COMPAT_DATETIMR = "yyyyMMddHHmmss";

    public static int dateNumber(int day) {
        return FakerDateTime.date2Number(FakerDateTime.date(FakerDateTime.getNowDateNumber(), day));
    }

    public static int dateNumber(int startDate, int endDate) {
        return FakerDateTime.date2Number(FakerDateTime.date(startDate, endDate));
    }

    public static Date date(int day) {
        return FakerDateTime.date(FakerDateTime.getNowDateNumber(), day);
    }

    public static Date date(int startDate, int endDate) {
        int a = startDate;
        int b = endDate;
        if (startDate > endDate) {
            a = endDate;
            b = startDate;
        }
        return FakerDateTime.date(FakerDateTime.number2Date(a), FakerDateTime.number2Date(b));
    }

    public static Date date(long longStartTime, long longEndTime) {
        long a = longStartTime;
        long b = longEndTime;
        if (longStartTime > longEndTime) {
            a = longEndTime;
            b = longStartTime;
        }
        return FakerDateTime.date(new Date(a), new Date(b));
    }

    public static Date date(Date start, Date end) {
        long b;
        long a = start.getTime();
        if (a > (b = end.getTime())) {
            a = end.getTime();
            b = start.getTime();
        }
        return new Date((long)((double)(b - a) * Math.random()) + a);
    }

    public static int getNowDateNumber() {
        return FakerDateTime.date2Number(new Date());
    }

    public static int getNowDatetimeNumber() {
        return FakerDateTime.datetime2Number(new Date());
    }

    public static int date2Number(Date date) {
        return FakerDateTime.datetime2Number(COMPAT_DATE, date);
    }

    public static int datetime2Number(Date datetime) {
        return FakerDateTime.datetime2Number(COMPAT_DATETIMR, datetime);
    }

    public static int datetime2Number(String pattern, Date datetime) {
        try {
            return Integer.valueOf(FakerDateTime.fromatDateTime(pattern, datetime));
        }
        catch (ParseException e) {
            return 0;
        }
    }

    public static Date number2Date(int numberDate) {
        return FakerDateTime.number2DateTime(COMPAT_DATE, numberDate);
    }

    public static Date number2DateTime(int numberDatetime) {
        return FakerDateTime.number2DateTime(COMPAT_DATETIMR, numberDatetime);
    }

    public static Date number2DateTime(String pattern, int date) {
        try {
            return FakerDateTime.parseDateTime(pattern, String.valueOf(date));
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    public static Date parseDateTime(String pattern, String date) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.parse(date);
    }

    public static String fromatDateTime(String pattern, Date date) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date);
    }
}

