/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.faker;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FakerPicker {
    public static final String DEFAULT_STRING_SPLIT = " ";

    public static <T> String putString(Set<T> set, int length) {
        return FakerPicker.putString(set, length, DEFAULT_STRING_SPLIT);
    }

    public static <T> String putString(Set<T> set, int length, String split) {
        StringBuilder sb = new StringBuilder();
        Set<T> sSet = FakerPicker.multiPick(set, length);
        for (T s : sSet) {
            sb.append(s).append(split);
        }
        return sb.toString();
    }

    public static <T> String putString(T[] set, int length) {
        return FakerPicker.putString(set, length, DEFAULT_STRING_SPLIT);
    }

    public static <T> String putString(T[] set, int length, String split) {
        StringBuilder sb = new StringBuilder();
        Set<T> sSet = FakerPicker.multiPick(set, length);
        for (T s : sSet) {
            sb.append(s).append(split);
        }
        if (sb.toString() != "") {
            sb.delete(sb.length() - 1, sb.length());
        }
        if (sb.toString().endsWith("\n")) {
            sb.delete(sb.length() - 1, sb.length());
        }
        return sb.toString();
    }

    public static String putString(Set<Map.Entry<String, String>> set, String split, String bothSplit) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : set) {
            if (builder.length() > 0) {
                builder.append(split);
            }
            builder.append(entry.getKey());
            builder.append(bothSplit);
            builder.append(entry.getValue());
        }
        if (builder.toString().endsWith("\n")) {
            builder.delete(builder.length() - 1, builder.length());
        }
        return builder.toString();
    }

    public static Map.Entry<String, String> splitString(String text, String split) {
        String[] values = text.split(split);
        if (values.length < 2) {
            return new AbstractMap.SimpleEntry<String, String>(values[0], "");
        }
        return new AbstractMap.SimpleEntry<String, String>(values[0], values[1]);
    }

    public static <T> T pick(Set<T> set) {
        if (set.size() == 0) {
            return null;
        }
        double v = (double)set.size() * Math.random();
        int count = 0;
        for (T t : set) {
            if (!((double)(++count) < v) && count < set.size()) continue;
            return t;
        }
        return null;
    }

    public static <K, V> K pick(Map<K, V> map) {
        if (map.size() == 0) {
            return null;
        }
        double v = (double)map.size() * Math.random();
        int count = 0;
        for (K k : map.keySet()) {
            if (!((double)(++count) < v) && count < map.size()) continue;
            return k;
        }
        return null;
    }

    public static <T> T pick(List<T> list) {
        if (list.size() == 0) {
            return null;
        }
        double v = (double)list.size() * Math.random();
        return list.get((int)v);
    }

    public static <T> T pick(T[] arr) {
        if (arr.length == 0) {
            return null;
        }
        double v = (double)arr.length * Math.random();
        return arr[(int)v];
    }

    public static <T, F> Map.Entry<T, F> pick(T[] arr, F[] arr2) {
        if (arr.length == 0) {
            return null;
        }
        double v = (double)arr.length * Math.random();
        double z = (double)arr2.length * Math.random();
        return new AbstractMap.SimpleEntry<T, F>(arr[(int)v], arr2[(int)z]);
    }

    public static <T> List<T> multiPick1(List<T> list, int amount) {
        return FakerPicker.multiPick1(list, amount, false);
    }

    public static <T> List<T> multiPick1(List<T> list, int amount, boolean isoverride) {
        LinkedList result = new LinkedList();
        LinkedList<T> temp = new LinkedList<T>(list);
        int count = amount;
        for (int index = 0; index < amount; ++index) {
            int select = (int)(Math.random() * (double)count);
            result.add(temp.get(select));
            temp.remove(select);
            --count;
        }
        return result;
    }

    public static <T> Set<T> multiPick(Set<T> set, int amount) {
        if (set.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<T> ret = new HashSet<T>(amount);
        for (int i = 0; i < amount; ++i) {
            ret.add(FakerPicker.pick(set));
        }
        return ret;
    }

    public static <K, V> Set<K> multiPick(Map<K, V> map, int amount) {
        if (map.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<K> ret = new HashSet<K>(amount);
        for (int i = 0; i < amount; ++i) {
            ret.add(FakerPicker.pick(map));
        }
        return ret;
    }

    public static <T> List<T> multiPick(List<T> list, int amount) {
        return FakerPicker.multiPick(list, amount, false);
    }

    public static <T> List<T> multiPick(List<T> list, int amount, boolean isoverride) {
        if (list.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> ret = new ArrayList<T>(amount);
        block0: for (int i = 0; i < amount; ++i) {
            if (isoverride) {
                for (int index = 0; index < 1000; ++index) {
                    T pick = FakerPicker.pick(list);
                    if (ret.contains(pick)) continue;
                    ret.add(pick);
                    continue block0;
                }
                continue;
            }
            ret.add(FakerPicker.pick(list));
        }
        return ret;
    }

    public static <T> Set<T> multiPick(T[] arr, int amount) {
        if (arr.length == 0) {
            return Collections.emptySet();
        }
        HashSet<T> ret = new HashSet<T>(amount);
        while (ret.size() < amount) {
            ret.add(FakerPicker.pick(arr));
        }
        return ret;
    }

    public static <T, F> Set<Map.Entry<T, F>> multiPick(T[] arr, F[] arr2, int amount) {
        if (arr.length == 0) {
            return Collections.emptySet();
        }
        HashSet<Map.Entry<T, F>> ret = new HashSet<Map.Entry<T, F>>(amount);
        while (ret.size() < amount) {
            ret.add(FakerPicker.pick(arr, arr2));
        }
        return ret;
    }

    public static Set<Map.Entry<String, String>> multiPick(String[] arr, String split, int amount) {
        if (arr.length == 0) {
            return Collections.emptySet();
        }
        HashSet<Map.Entry<String, String>> ret = new HashSet<Map.Entry<String, String>>(amount);
        while (ret.size() < amount) {
            ret.add(FakerPicker.splitString(FakerPicker.pick(arr), split));
        }
        return ret;
    }
}

