/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.faker;

import cn.net.vidyo.faker.FakerPicker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class AbstractFaker {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    public HashMap<String, String[]> cacheMap = new HashMap();
    public static final String DEFAULT_SPLIT = "\r\n";
    public static final String DEFAULT_BASE_PATH = "/cn/net/vidyo/faker/resources";
    public static final String DEFAULT_STRING_SPLIT = " ";
    public static final String DEFAULT_NULL_SPLIT = "";
    public static final String DEFAULT_TAB_SPLIT = "\t";

    public File getClassPathResourceFile(String resourceString) {
        ClassPathResource resource = new ClassPathResource(resourceString);
        try {
            return resource.getFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String pick(String key, String split) {
        return this.pick(key, 1, split);
    }

    public String pick(String key) {
        return this.pick(key, 1);
    }

    public String pick(String key, int len) {
        return this.pick(key, len, DEFAULT_STRING_SPLIT);
    }

    public String pick(String key, int len, String split) {
        if (!this.isLoad(key)) {
            return DEFAULT_NULL_SPLIT;
        }
        StringBuilder builder = new StringBuilder();
        String[] caches = this.cacheMap.get(key);
        return FakerPicker.putString(caches, len, split);
    }

    public Map.Entry<String, String> bothPick(String key1, String key2) {
        String[] caches1 = this.getMap(key1);
        String[] caches2 = this.getMap(key2);
        return FakerPicker.pick(caches1, caches2);
    }

    public Set<String> multiPick(String key, int len) {
        String[] caches = this.getMap(key);
        return FakerPicker.multiPick(caches, len);
    }

    public Set<Map.Entry<String, String>> multiPick(String key1, String key2, int amount) {
        String[] caches1 = this.getMap(key1);
        String[] caches2 = this.getMap(key2);
        return FakerPicker.multiPick(caches1, caches2, amount);
    }

    public boolean isLoad(String key) {
        if (this.cacheMap.containsKey(key)) {
            return true;
        }
        this.putResourceMapByName(key, this.getKeyName(key));
        return this.cacheMap.containsKey(key);
    }

    public String[] getMap(String key) {
        if (!this.isLoad(key)) {
            return new String[0];
        }
        return this.cacheMap.get(key);
    }

    protected String getKeyName(String key) {
        return DEFAULT_NULL_SPLIT;
    }

    public String[] putResourceStringMap(String resourceString) {
        return this.putResourceStringMap(resourceString, DEFAULT_SPLIT);
    }

    public String[] putResourceStringMap(String resourceString, String split) {
        ClassPathResource resource = new ClassPathResource(resourceString);
        this.logger.debug("read resource " + resourceString);
        try {
            return FileUtils.readFileToString((File)resource.getFile(), (String)"utf8").split(split);
        }
        catch (FileNotFoundException e) {
            return AbstractFaker.getJarResource(this.getClass(), resourceString, "utf8").split(split);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getJarResource(Class javaClass, String path, String encoding) {
        URL url = javaClass.getResource(path);
        StringBuilder builder = new StringBuilder();
        try {
            String str;
            InputStream stream = url.openStream();
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(stream, encoding));
            while ((str = bufferedreader.readLine()) != null) {
                builder.append(str + DEFAULT_SPLIT);
            }
            stream.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return builder.toString();
    }

    public void putResourceMap(String key, String resourceString) {
        this.putResourceMap(key, resourceString, DEFAULT_SPLIT);
    }

    public void putResourceMap(String key, String resourceString, String split) {
        String[] map = this.putResourceStringMap(resourceString, split);
        this.cacheMap.put(key, map);
    }

    public void putResourceMapByName(String key, String name) {
        this.putResourceMapByName(key, name, DEFAULT_SPLIT);
    }

    public void putResourceMapByName(String key, String name, String split) {
        this.putResourceMap(key, "/cn/net/vidyo/faker/resources/" + name, split);
    }
}

