package cn.net.vidyo.dylink.mybatis.plus.util;

import cn.hutool.core.bean.BeanUtil;
import cn.net.vidyo.dylink.mybatis.plus.entity.CommonList;
import cn.net.vidyo.dylink.mybatis.plus.entity.CommonPage;
import cn.net.vidyo.framework.common.data.domain.Converter;
import cn.net.vidyo.framework.common.data.domain.MapConverter;
import cn.net.vidyo.framework.common.domain.Result;
import com.baomidou.mybatisplus.core.metadata.IPage;

import java.util.*;

public class ResultConvert {

    //<editor-fold desc="view object">
    public static <OUT> Result convertObjectToResult(Object entity, Converter<OUT> converter) {
        OUT vo = convertObject(entity, converter);
        return Result.Success(vo);
    }

    public static <OUT> Result convertCollectionToResult(Collection entities, Converter<OUT> converter) {
        List<OUT> list = convertCollection(entities, converter);
        return Result.Success(list);
    }
    public static <OUT> Result convertListToResult(List entities, Converter<OUT> converter) {
        return convertCollectionToResult(entities,converter);
    }

    public static <OUT> Result convertPageToResult(IPage page, Converter<OUT> converter) {
        IPage<OUT> pageResult = convertPage(page, converter);
        return Result.Success(pageResult);
    }
    public static <OUT> Result convertPageToMapResult(IPage page, Converter<OUT> converter) {
        Map pageResult = convertPageToMap(page, converter);
        return Result.Success(pageResult);
    }
    //</editor-fold>
    //<editor-fold desc="view object">
    public static <OUT> List<OUT> convertList(List entities, Converter<OUT> converter) {
        return convertCollection(entities,converter);
    }
    public static <OUT> List<OUT> convertCollection(Collection entities, Converter<OUT> converter) {
        CommonList<OUT> list = new CommonList<>();
        Map<String,Object> params = new LinkedHashMap<>();
        try {
            for (Object entity : entities) {
                OUT out = (OUT)converter.getOutClass().newInstance();
                BeanUtil.copyProperties(entity,out);
                list.add(converter.convert(entity,out,params));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        list.setParams(params);
        return list;
    }

    public static <OUT> OUT convertObject(Object entity, Converter<OUT> converter) {
        OUT out = null;
        try {
            Map<String,Object> params = new LinkedHashMap<>();
            out = (OUT)converter.getOutClass().newInstance();
            BeanUtil.copyProperties(entity,out);
            out = converter.convert(entity,out,params);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return out;
    }

    public static <OUT> IPage<OUT> convertPage(IPage page, Converter<OUT> converter) {
        CommonList<OUT> list = new CommonList<>();
        Map<String,Object> params = new LinkedHashMap<>();
        try {
            for (Object entity : page.getRecords()) {
                OUT out = (OUT)converter.getOutClass().newInstance();
                BeanUtil.copyProperties(entity,out);
                list.add(converter.convert(entity,out,params));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        try {
            CommonPage<OUT> newpage = new CommonPage<>();
            newpage.setParams(params);
            newpage.setPages(page.getPages());
            newpage.setCurrent(page.getCurrent());
            newpage.setSize(page.getSize());
            newpage.setRecords(list);
            newpage.setTotal(page.getTotal());
            return newpage;
        } catch (Exception e) {
            return null;
        }
    }
    public static <OUT> Map convertPageToMap(IPage page, Converter<OUT> converter) {
        CommonList<OUT> list = new CommonList<>();
        Map<String,Object> params = new LinkedHashMap<>();
        try {
            for (Object entity : page.getRecords()) {
                OUT out = (OUT)converter.getOutClass().newInstance();
                BeanUtil.copyProperties(entity,out);
                list.add(converter.convert(entity,out,params));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Map map =new HashMap();
            map.put("params",params);
            map.put("pages",page.getPages());
            map.put("current",page.getCurrent());
            map.put("size",page.getSize());
            map.put("records",list);
            map.put("total",page.getTotal());
            return map;
        } catch (Exception e) {
            return null;
        }
    }
    //</editor-fold>
    //<editor-fold desc="view object">
    public static List<Map<String,Object>> convertMapList(List entities, MapConverter converter) {
        return convertMapCollection(entities,converter);
    }
    public static List<Map<String,Object>> convertMapCollection(Collection entities, MapConverter converter) {
        CommonList<Map<String,Object>> list = new CommonList<>();
        Map<String,Object> params = new LinkedHashMap<>();
        try {
            for (Object entity : entities) {
                Map<String,Object> out = BeanUtil.beanToMap(entity);
                list.add(converter.convert(entity,out,params));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        list.setParams(params);
        return list;
    }

    public static Map<String,Object> convertMap(Object entity, MapConverter converter) {
        Map<String,Object> out = new HashMap<>();
        try {
            Map<String,Object> params = new LinkedHashMap<>();
            out = BeanUtil.beanToMap(entity);
            out = converter.convert(entity,out,params);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return out;
    }

    public static IPage<Map<String,Object>> convertMapPage(IPage page, MapConverter converter) {
        CommonList<Map<String,Object>> list = new CommonList<>();
        Map<String,Object> params = new LinkedHashMap<>();
        try {
            for (Object entity : page.getRecords()) {
                Map<String,Object> out = BeanUtil.beanToMap(entity);
                list.add(converter.convert(entity,out,params));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        try {
            CommonPage<Map<String,Object>> newpage = new CommonPage<>();
            newpage.setParams(params);
            newpage.setPages(page.getPages());
            newpage.setCurrent(page.getCurrent());
            newpage.setSize(page.getSize());
            newpage.setRecords(list);
            newpage.setTotal(page.getTotal());
            return newpage;
        } catch (Exception e) {
            return null;
        }
    }
    //</editor-fold>

}
