package cn.net.vidyo.dylink.mybatis.plus.util;

import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import cn.net.vidyo.dylink.mybatis.plus.enums.BusinessExceptionEnum;
import cn.net.vidyo.dylink.mybatis.plus.util.excel.ColException;
import cn.net.vidyo.dylink.mybatis.plus.util.excel.ExcelImportProcess;
import cn.net.vidyo.framework.common.domain.Result;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExcelImportUtil {
    public static Result importExcel(File file, int sheetIndex, int startRowIndex, ExcelImportProcess process) {
        return importExcelWithMultiSheet(file, process, sheetIndex, startRowIndex);
    }

    public static Result importExcelWithMultiSheet(File file, ExcelImportProcess process, int... sheetIndexAndstartRowIndexs) {
        InputStream inputStream;
        try {
            inputStream = new FileInputStream(file);
        } catch (Exception e) {
            return Result.Fail(BusinessExceptionEnum.EXCEL_IMPORT_ACCESS_EXCEPTION);
        }
        return importExcelWithMultiSheet(inputStream, process, sheetIndexAndstartRowIndexs);
    }

    public static Result importExcelWithMultiSheet(InputStream inputStream, ExcelImportProcess process, int... sheetIndexAndstartRowIndexs) {
        Map<Integer, Map<Integer, List<Object>>> sheetsData = new HashMap<>();
        List<ColException> errors = new ArrayList<>();
        try {
            for (int index = 0; index < sheetIndexAndstartRowIndexs.length; index++) {
                int sheetIndex = sheetIndexAndstartRowIndexs[index];
                int startRowIndex = sheetIndexAndstartRowIndexs[index + 1];
                index++;
                Map<Integer, List<Object>> sheetData = new HashMap<>();
                ExcelReader reader = ExcelUtil.getReader(inputStream, sheetIndex); //指定输入流和sheet
                // 读取第二行到最后一行数据
                List<List<Object>> read = reader.read(startRowIndex, reader.getRowCount());
                int rowIndex = startRowIndex;
                for (List<Object> rowData : read) {
                    sheetData.put(rowIndex, rowData);
                    Result check = process.check(sheetIndex, rowIndex, rowData);
                    if (!check.isSuccess()) {
                        List<ColException> errs = (List<ColException>) check.getData();
                        errors.addAll(errs);
                    }
                    rowIndex++;
                }
                Result check = process.checkSheet(sheetIndex, sheetData);
                if (!check.isSuccess()) {
                    List<ColException> errs = (List<ColException>) check.getData();
                    errors.addAll(errs);
                }
                sheetsData.put(sheetIndex, sheetData);
            }
        }catch (Exception ex){
            ex.printStackTrace();
            if(ex!=null && ex.getMessage()!=null && ex.getMessage().indexOf("OOXML")>0){
                return Result.Fail(BusinessExceptionEnum.EXCEL_IMPORT_FORMAT_EXCEPTION);
            }
            return Result.Fail(BusinessExceptionEnum.EXCEL_IMPORT_FORMAT_EXCEPTION);
        }
        if (errors.size() > 0) {
            return Result.Fail(BusinessExceptionEnum.EXCEL_IMPORT_Data_EXCEPTION, errors);
        }
        for (Map.Entry<Integer, Map<Integer, List<Object>>> sheetEntry : sheetsData.entrySet()) {
            int sheetIndex = sheetEntry.getKey();
            for (Map.Entry<Integer, List<Object>> entry : sheetEntry.getValue().entrySet()) {
                Result check = process.process(sheetIndex, entry.getKey(), entry.getValue());
                if (!check.isSuccess()) {
                    List<ColException> errs = (List<ColException>) check.getData();
                    errors.addAll(errs);
                    return Result.Fail(BusinessExceptionEnum.EXCEL_IMPORT_Data_EXCEPTION, errors);
                }
            }
        }

        return Result.Success();
    }
}
