package cn.net.vidyo.dylink.mybatis.plus.util;


import cn.net.vidyo.dylink.mybatis.plus.service.EntityService;
import cn.net.vidyo.dylink.mybatis.plus.util.excel.ColException;
import cn.net.vidyo.dylink.mybatis.plus.util.excel.ColExceptionType;
import cn.net.vidyo.framework.common.util.ValueUtil;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ColCheckBuilder {
    List<ColException> exceptions = new ArrayList<>();

    public void addException(ColException e) {
        exceptions.add(e);
    }

    public static ColCheckBuilder instaance() {
        ColCheckBuilder builder = new ColCheckBuilder();
        return builder;
    }

    public ColCheckBuilder check(int sheetIndex, int rowIndex, int colIndex, Object value, ColExceptionType... types) {
        Map<Integer, ColException> map = new HashMap();
        for (ColExceptionType colExceptionType : types) {
            ColException exception = null;
            boolean throwException = false;
            if (value == null) {
                if (colExceptionType == ColExceptionType.IS_NULL) {
                    return null;
                }
                throwException = true;
                colExceptionType = ColExceptionType.IS_NOT_NULL;
            } else {
                switch (colExceptionType) {
                    case IS_NOT_BLANK:
                        throwException = StringUtils.isNotBlank(value.toString());
                        break;
                    case IS_BLANK:
                        throwException = StringUtils.isBlank(value.toString());
                        break;
                    case IS_EMPTY:
                        throwException = StringUtils.isEmpty(value.toString());
                        break;
                    case IS_NOT_EMPTY:
                        throwException = StringUtils.isNotEmpty(value.toString());
                        break;
                    case IS_NOT_NUMBER:
                        throwException = StringUtils.isNumeric(value.toString());
                        break;
                    case IS_NOT_MOBILE:
                        throwException = ValueUtil.isMobile(value.toString());
                        break;
                    case IS_NOT_EMAIL:
                        throwException = ValueUtil.isEmail(value.toString());
                        break;

                }
            }
            if (throwException) {
                exception = new ColException();
                exception.setCol(colIndex);
                exception.setRow(rowIndex);
                exception.setSheet(sheetIndex);
                exception.setType(colExceptionType.ordinal());
                map.put(exception.getType(), exception);
            }
        }
        List<ColException> list = new ArrayList<>();
        for (Map.Entry<Integer, ColException> entry : map.entrySet()) {
            list.add(entry.getValue());
        }
        exceptions.addAll(list);
        return this;
    }
    public ColCheckBuilder checkNameExist(int sheetIndex, int rowIndex, int colIndex, Object value, EntityService entityService, String messsage){
        if(value==null){
            return this;
        }
        Object entity = entityService.getByName(value.toString().trim());
        if (entity != null)
            return this;
        ColException exception = new ColException();
        exception.setType(ColExceptionType.IS_NOT_EXIST_NAME.ordinal());
        exception.setCol(colIndex);
        exception.setRow(rowIndex);
        exception.setSheet(sheetIndex);
        exception.setMessage(messsage);
        exceptions.add(exception);
        return this;
    }

    public List<ColException> build() {
        return exceptions;
    }
}
