package cn.net.vidyo.dylink.mybatis.plus.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.db.PageResult;
import cn.net.vidyo.dylink.mybatis.plus.dao.EntityDao;
import cn.net.vidyo.dylink.mybatis.plus.service.EntityService;
import cn.net.vidyo.framework.common.data.domain.Model;
import cn.net.vidyo.framework.common.util.ReflectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class EntityServiceImpl<DAO extends EntityDao<MODEL>, MODEL, KEY extends Serializable> extends ServiceImpl<DAO, MODEL> implements EntityService<DAO, MODEL, KEY> {
    Class<KEY> keyClass;
    public EntityServiceImpl() {
        parseClass();
    }

    protected void parseClass(){
        Class<MODEL> entityClass = super.getEntityClass();
        Field field = ReflectUtil.getAllDeclaredFields(entityClass, "id", true);
        if(field!=null){
            if(field.getType()==Integer.class){
                keyClass=(Class<KEY>)Integer.class;
            }
            if(field.getType()==Long.class){
                keyClass=(Class<KEY>)Long.class;
            }
            if(field.getType()==String.class){
                keyClass=(Class<KEY>)String.class;
            }
        }
    }

    @Override
    public DAO getEntityDao() {
        return baseMapper;
    }


    @Override
    public void setEntityDao(DAO entityDao) {
        this.baseMapper = entityDao;

    }

    //<editor-fold desc="baseMapper">


//    @Override
//    public boolean update(MODEL model) {
//        return super.updateById(model);
//    }

    @Override
    public int truncate() {
        return this.baseMapper.truncate();
    }

    @Override
    public int drop() {
        return this.baseMapper.drop();
    }

    public int insert(MODEL entity) {
        return baseMapper.insert(entity);
    }

    public int deleteById(Serializable id) {
        return baseMapper.deleteById(id);
    }

    public int deleteByMap(Map<String, Object> columnMap) {
        return baseMapper.deleteByMap(columnMap);
    }

    protected int deleteByWhere(Wrapper<MODEL> wrapper) {
        return baseMapper.delete(wrapper);
    }

    public int deleteBatchIds(Collection<? extends Serializable> idList) {
        return baseMapper.deleteBatchIds(idList);
    }

    public MODEL selectById(Serializable id) {
        return baseMapper.selectById(id);
    }

    public List<MODEL> selectBatchIds(Collection<? extends Serializable> idList) {
        return baseMapper.selectBatchIds(idList);
    }

    public List<MODEL> selectByMap(Map<String, Object> columnMap) {
        return baseMapper.selectByMap(columnMap);
    }

    protected MODEL selectOneByWhere(Wrapper<MODEL> queryWrapper) {
        return baseMapper.selectOne(queryWrapper);
    }

    protected long selectCountByWhere(Wrapper<MODEL> queryWrapper) {
        return baseMapper.selectCount(queryWrapper);
    }

    protected List<MODEL> selectListByWhere(Wrapper<MODEL> queryWrapper) {
        return baseMapper.selectList(queryWrapper);
    }

    protected List<Map<String, Object>> selectMapsByWhere(Wrapper<MODEL> queryWrapper) {
        return baseMapper.selectMaps(queryWrapper);
    }

    protected List<Object> selectObjsByWhere(Wrapper<MODEL> queryWrapper) {
        return baseMapper.selectObjs(queryWrapper);
    }

    protected <E extends IPage<MODEL>> E selectPageByWhere(E page, Wrapper<MODEL> queryWrapper) {
        return baseMapper.selectPage(page, queryWrapper);
    }

    protected <E extends IPage<Map<String, Object>>> E selectMapsPageByWhere(E page, Wrapper<MODEL> queryWrapper) {
        return baseMapper.selectMapsPage(page, queryWrapper);
    }


    //</editor-fold>

    //<editor-fold desc="entityService">
    public List<MODEL> findByIds(Collection<KEY> ids) {
        return this.baseMapper.selectList(new QueryWrapper<MODEL>().eq("hidden", false).in("id", ids));
    }

    public MODEL getByName(String name) {
        List<MODEL> entities = this.baseMapper.selectList(new QueryWrapper<MODEL>().eq("hidden", false).eq(StringUtils.isNotBlank(name), "name", name));
        if (entities.size() == 0) {
            return null;
        }
        return entities.get(0);
    }

    public int logicDeleteByIds(boolean hidden, KEY... ids) {
        List<KEY> deleteIds = new ArrayList<>();
        for (KEY id : ids) {
            deleteIds.add(id);
        }
        int index = 0;
        List<MODEL> list = findByIds(deleteIds);
        for (MODEL t : list) {
            BeanUtil.setFieldValue(t, "hidden", hidden);
            boolean save = updateById(t);
            if (save) {
                index++;
            }
        }
        return index;
    }

    @Override
    public List<MODEL> findAll() {
        QueryWrapper<MODEL> wrapper = new QueryWrapper<>();
        wrapper.eq("hidden",false);
        return list(wrapper);
    }
    @Override
    public <E extends IPage<MODEL>> E findAll(E page) {
        QueryWrapper<MODEL> wrapper = new QueryWrapper<>();
        wrapper.eq("hidden",false);
        return page(page,wrapper);
    }

    @Override
    public String getNameById(KEY id) {
        MODEL entity = getById(id);
        if (entity == null) return "";
        Object value = BeanUtil.getFieldValue(entity, "name");
        if (value == null) return "";
        return value.toString();
    }

    @Override
    public <C> C getColumnById(Class<C> cClass, KEY id, String fileName) {
        MODEL entity = getById(id);
        if (entity == null) return null;
        Object value = BeanUtil.getFieldValue(entity, fileName);
        return (C) value;
    }

    protected List<KEY> findIdsByWhere(String columName, QueryWrapper<MODEL> where) {
        return findColumnsByWhere("id",getKeyClass(), where);
    }

    public  Class<KEY> getKeyClass(){
        return null;
    }
    public Class<MODEL> getEntityClass(){
        return null;
    }

    protected <C> List<C> findColumnsByWhere(String columName,Class<C> cClass, QueryWrapper<MODEL> where) {
        where.select(columName);
        return this.baseMapper.selectObjs(where).stream().map(o -> (C) o).collect(Collectors.toList());
    }

    protected <C> C getColumnsByWhere(String columName,Class<C> cClass, QueryWrapper<MODEL> where) {
        List<C> columns = findColumnsByWhere(columName,cClass, where);
        if (columns == null || columns.size() == 0) return null;
        return columns.get(0);
    }

    @Override
    public boolean save(MODEL entity) {
        if(!((Model)entity).isModify()){
            ((Model)entity).preInsert();
        }else{
            ((Model)entity).preUpdate();
        }
        return super.save(entity);
    }


    @Override
    public boolean saveBatch(Collection<MODEL> entityList) {
        for (MODEL model : entityList) {
            if(!((Model)model).isModify()){
                ((Model)model).preInsert();
            }else{
                ((Model)model).preUpdate();
            }
        }
        return super.saveBatch(entityList);
    }

    @Override
    public boolean saveOrUpdateBatch(Collection<MODEL> entityList) {
        for (MODEL model : entityList) {
            if(!((Model)model).isModify()){
                ((Model)model).preInsert();
            }else{
                ((Model)model).preUpdate();
            }
        }
        return super.saveOrUpdateBatch(entityList);
    }

    @Override
    public boolean saveBatch(Collection<MODEL> entityList, int batchSize) {
        for (MODEL model : entityList) {
            if(!((Model)model).isModify()){
                ((Model)model).preInsert();
            }else{
                ((Model)model).preUpdate();
            }
        }
        return super.saveBatch(entityList, batchSize);
    }

    @Override
    public boolean saveOrUpdate(MODEL entity) {
        if(!((Model)entity).isModify()){
            ((Model)entity).preInsert();
        }else{
            ((Model)entity).preUpdate();
        }
        return super.saveOrUpdate(entity);
    }

    @Override
    public boolean saveOrUpdateBatch(Collection<MODEL> entityList, int batchSize) {
        for (MODEL model : entityList) {
            if(!((Model)model).isModify()){
                ((Model)model).preInsert();
            }else{
                ((Model)model).preUpdate();
            }
        }
        return super.saveOrUpdateBatch(entityList, batchSize);
    }
    @Override
    public boolean delete(MODEL entity) {
        return removeById(entity);
    }

    @Override
    public boolean update(MODEL entity) {
        return updateById(entity);
    }

    @Override
    public boolean updateById(MODEL entity) {
        if(!((Model)entity).isModify()){
            ((Model)entity).preInsert();
        }else{
            ((Model)entity).preUpdate();
        }
        return super.updateById(entity);
    }

    @Override
    public boolean update(MODEL entity, Wrapper<MODEL> updateWrapper) {
        if(!((Model)entity).isModify()){
            ((Model)entity).preInsert();
        }else{
            ((Model)entity).preUpdate();
        }
        return super.update(entity, updateWrapper);
    }

    @Override
    public boolean updateBatchById(Collection<MODEL> entityList) {
        return super.updateBatchById(entityList);
    }

    @Override
    public boolean saveOrUpdate(MODEL entity, Wrapper<MODEL> updateWrapper) {
        if(!((Model)entity).isModify()){
            ((Model)entity).preInsert();
        }else{
            ((Model)entity).preUpdate();
        }
        return super.saveOrUpdate(entity, updateWrapper);
    }

    public KEY getMaxId() {
        return getColumnsByWhere("max(id) as id",getKeyClass(), new QueryWrapper<>());
    }

    public void setEntityClass(Class<MODEL> entityClass) {
        this.entityClass = entityClass;
    }

    public void setKeyClass(Class<KEY> keyClass) {
        this.keyClass = keyClass;
    }
//</editor-fold>
}
