package cn.net.vidyo.dylink.mybatis.plus.service;

import cn.net.vidyo.dylink.mybatis.plus.dao.EntityDao;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import org.apache.ibatis.annotations.Param;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface EntityService<DAO extends EntityDao<MODEL>, MODEL, KEY extends Serializable> extends IService<MODEL> {

    DAO getEntityDao();
    void setEntityDao(DAO entityDao);

    //<editor-fold desc="Description">

    int truncate();
    int drop();
    int insert(MODEL entity);
    boolean update(MODEL entity);

    boolean delete(MODEL entity);

    int deleteById(Serializable id);

    int deleteByMap(@Param("cm") Map<String, Object> columnMap);


    int deleteBatchIds(@Param("coll") Collection<? extends Serializable> idList);

    MODEL selectById(Serializable id);

    List<MODEL> selectBatchIds(@Param("coll") Collection<? extends Serializable> idList);

    List<MODEL> selectByMap(@Param("cm") Map<String, Object> columnMap);

    List<MODEL> findAll();
    <E extends IPage<MODEL>> E findAll(E page);


    //</editor-fold>
    //<editor-fold desc="Description">
    List<MODEL> findByIds(Collection<KEY> ids);

    MODEL getByName(String name);

    String getNameById(KEY id);

    <C> C getColumnById(Class<C> cClass, KEY id, String fileName);


    int logicDeleteByIds(boolean hidden, KEY... ids);
    //</editor-fold>




}
