package cn.net.vidyo.dylink.mybatis.plus.enums;


import cn.net.vidyo.framework.common.domain.IErrorEnum;

public enum BusinessExceptionEnum implements IErrorEnum {
    // 400
    BAD_REQUEST(400, "请求数据格式不正确!"),
    UNAUTHORIZED(401, "登录凭证过期!"),
    FORBIDDEN(403, "没有访问权限!"),
    NOT_FOUND(404, "请求的资源找不到!"),
    // 500
    INTERNAL_SERVER_ERROR(500, "服务器内部错误!"),
    SERVICE_UNAVAILABLE(503, "服务器正忙，请稍后再试!"),
    // 未知异常
    UNKNOWN(10000, "未知异常!"),
    // 自定义
    IS_NOT_NULL(10001,"%s不能为空"),

    EXCEL_IMPORT_ACCESS_EXCEPTION(12000,"Excel 导入操作错误"),
    EXCEL_IMPORT_Data_EXCEPTION(12001,"Excel 导入数据错误"),
    EXCEL_IMPORT_FORMAT_EXCEPTION(12002,"Excel 导入文件格式错误"),
    TREE_HAVE_CHILREND(13000,"所选节点有子节点无法删除");
    ;

    /**
     * 错误码
     */
    private int code;

    /**
     * 错误描述
     */
    private String display;

    BusinessExceptionEnum(Integer code, String msg) {
        this.code = code;
        this.display = msg;
    }

    public int getCode() {
        return code;
    }

    public String getDisplay() {
        return display;
    }
}
