package cn.net.vidyo.dylink.mybatis.plus.util;



import cn.net.vidyo.dylink.mybatis.plus.util.excel.ColException;
import cn.net.vidyo.dylink.mybatis.plus.util.excel.ColExceptionType;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExcelColExceptionUtil {
    public List<ColException> check(Object value, ColExceptionType... types){
        Map<Integer, ColException> map = new HashMap();
        for (ColExceptionType colExceptionType : types) {
            ColException exception=null;
            switch (colExceptionType){
                case IS_NOT_BLANK:
                    exception =checkIsNull(value);
                    break;
                case IS_NOT_NUMBER:
                    exception =checkIsNumber(value);
                    break;
                case IS_NOT_MOBILE:
                    exception =checkIsMobile(value);
                    break;
            }
            if(exception!=null && !map.containsKey(exception.getType())){
                map.put(exception.getType(),exception);
            }
        }
        List<ColException> list = new ArrayList<>();
        for (Map.Entry<Integer, ColException> entry : map.entrySet()) {
            list.add(entry.getValue());
        }
        return list;
    }
    public ColException checkIsNull(Object value){
        if(value!=null)
            return null;
        ColException exception=new ColException();
        exception.setType(ColExceptionType.IS_NOT_BLANK.ordinal());
        exception.setMessage(ColExceptionType.IS_NOT_BLANK.getRemark());
        return exception;
    }
    public ColException checkIsNumber(Object value){
        ColException exception = checkIsNull(value);
        if(exception!=null)
            return exception;
        if(value!=null)
            return null;
        exception=new ColException();
        exception.setType(ColExceptionType.IS_NOT_NUMBER.ordinal());
        exception.setMessage(ColExceptionType.IS_NOT_NUMBER.getRemark());
        return exception;
    }
    public ColException checkIsMobile(Object value){
        ColException exception = checkIsNull(value);
        if(exception!=null)
            return exception;
        if(value!=null)
            return null;
        exception=new ColException();
        exception.setType(ColExceptionType.IS_NOT_MOBILE.ordinal());
        exception.setMessage(ColExceptionType.IS_NOT_MOBILE.getRemark());
        return exception;
    }
}
