package cn.net.vidyo.dylink.mybatis.plus.service.impl;

import cn.net.vidyo.dylink.mybatis.plus.service.EntityConditionService;
import cn.net.vidyo.dylink.mybatis.plus.dao.EntityDao;
import cn.net.vidyo.framework.common.data.domain.Condition;
import cn.net.vidyo.framework.common.data.domain.Converter;
import cn.net.vidyo.dylink.mybatis.plus.util.ResultConvert;
import cn.net.vidyo.framework.common.domain.Result;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.lang3.NotImplementedException;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public abstract class EntityConditionServiceImpl<DAO extends EntityDao<MODEL>, MODEL, KEY extends Serializable, CONDITION extends Condition> extends EntityServiceImpl<DAO, MODEL, KEY> implements EntityConditionService<DAO, MODEL, KEY, CONDITION> {
    //<editor-fold desc="base conditon">

    //<editor-fold desc="get">
    public MODEL getOneByCondition(CONDITION condition) {
        return getOne(buildQueryCondition(condition));
    }

    public Map<String, Object> getMapByCondition(CONDITION condition) {
        return getMap(buildQueryCondition(condition));
    }

    public <V> V getObjByCondition(CONDITION condition, Function<? super Object, V> mapper) {
        return getObj(buildQueryCondition(condition), mapper);
    }
    //</editor-fold>

    //<editor-fold desc="list">
    public List<KEY> findIdsByCondition(CONDITION condition) {
        return findColumnsByWhere("id",getKeyClass(),buildQueryCondition(condition));
    }
    public List<MODEL> listByCondition(CONDITION condition) {
        return list(buildQueryCondition(condition));
    }

    public List<Map<String, Object>> listMapsByCondition(CONDITION condition) {
        return listMaps(buildQueryCondition(condition));
    }

    public List<Map<String, Object>> listMapsByCondition(CONDITION condition, QueryWrapper<MODEL> wrapper) {
        return listMaps(buildQueryCondition(condition, wrapper));
    }

    public List<Object> listObjsByCondition(CONDITION condition) {
        return listObjs(buildQueryCondition(condition));
    }

    public List<Object> listObjsByCondition(CONDITION condition, QueryWrapper<MODEL> wrapper) {
        return listObjs(buildQueryCondition(condition, wrapper));
    }

    public <V> List<V> listObjsByCondition(CONDITION condition, Function<? super Object, V> mapper) {
        return listObjs(buildQueryCondition(condition), mapper);
    }

    public <V> List<V> listObjsByCondition(CONDITION condition, Function<? super Object, V> mapper, QueryWrapper<MODEL> wrapper) {
        return listObjs(buildQueryCondition(condition, wrapper), mapper);
    }
    //</editor-fold>

    //<editor-fold desc="page">
    public IPage<MODEL> pageByCondition(CONDITION condition) {
        Page<MODEL> page = new Page<>(condition.getPageNumber(), condition.getPageSize());
        return page(page, buildQueryCondition(condition));
    }

    public IPage<MODEL> pageByCondition(CONDITION condition, QueryWrapper<MODEL> wrapper) {
        Page<MODEL> page = new Page<>(condition.getPageNumber(), condition.getPageSize());
        return page(page, buildQueryCondition(condition, wrapper));
    }

    public IPage<Map<String, Object>> pageMapsByCondition(CONDITION condition) {
        Page<Map<String, Object>> page = new Page<>(condition.getPageNumber(), condition.getPageSize());
        return pageMaps(page, buildQueryCondition(condition));
    }

    public IPage<Map<String, Object>> pageMapsByCondition(CONDITION condition, QueryWrapper<MODEL> wrapper) {
        Page<Map<String, Object>> page = new Page<>(condition.getPageNumber(), condition.getPageSize());
        return pageMaps(page, buildQueryCondition(condition, wrapper));
    }
    //</editor-fold>

    //<editor-fold desc="count">
    public long countByCondition(CONDITION condition) {
        return count(buildQueryCondition(condition));
    }
    //</editor-fold>


    //<editor-fold desc="update">
    public boolean updateByCondition(CONDITION condition, UpdateWrapper<MODEL> updateWrapper) {
        updateWrapper = buildUpdateCondition(condition, updateWrapper);
        return update(updateWrapper);
    }

    public boolean incrementColumnByCondition(CONDITION condition, String column, Serializable delta) {
        UpdateWrapper<MODEL> updateWrapper = new UpdateWrapper<>();
        updateWrapper.setSql(column + "=" + column + "+" + delta);
        updateWrapper = buildUpdateCondition(condition, updateWrapper);
        return update(updateWrapper);
    }


    //</editor-fold>

    //<editor-fold desc="delete">
    public boolean deleteByCondition(CONDITION condition) {
        QueryWrapper<MODEL> updateWrapper = buildQueryCondition(condition);
        return super.remove(updateWrapper);
    }

    public boolean logicDeleteByCondition(CONDITION condition, boolean hidden) {
        UpdateWrapper<MODEL> updateWrapper = new UpdateWrapper<>();
        updateWrapper.set("hidden", hidden);
        return updateByCondition(condition, updateWrapper);
    }
    //</editor-fold>

    //</editor-fold>

    //<editor-fold desc="result conditon">

    //<editor-fold desc="get">
    public Result getOneResultByCondition(CONDITION condition, Converter converter) {
        MODEL model = getOneByCondition(condition);
        return ResultConvert.convertObjectToResult(model,converter);
    }

    public Result getMapResultByCondition(CONDITION condition, Converter converter) {
        Map<String, Object> model = getMapByCondition(condition);
        return ResultConvert.convertObjectToResult(model,converter);
    }

    public <V> Result getObjResultByCondition(CONDITION condition, Converter converter, Function<? super Object, V> mapper) {
        V model = getObjByCondition(condition, mapper);
        return ResultConvert.convertObjectToResult(model,converter);
    }
    //</editor-fold>

    //<editor-fold desc="list">
    public Result listResultByCondition(CONDITION condition, Converter converter) {
        List<MODEL> list = listByCondition(condition);
        return ResultConvert.convertListToResult(list,converter);
    }

    public Result listMapsResultByCondition(CONDITION condition, Converter converter) {
        List<Map<String, Object>> list = listMapsByCondition(condition);
        return ResultConvert.convertListToResult(list,converter);
    }

    public Result listMapsResultByCondition(CONDITION condition, Converter converter, QueryWrapper<MODEL> wrapper) {
        List<Map<String, Object>> list = listMapsByCondition(condition, wrapper);
        return ResultConvert.convertListToResult(list,converter);
    }

    public Result listObjsResultByCondition(CONDITION condition, Converter converter) {
        List<Object> list = listObjsByCondition(condition);
        return ResultConvert.convertListToResult(list,converter);
    }

    public Result listObjsResultByCondition(CONDITION condition, Converter converter, QueryWrapper<MODEL> wrapper) {
        List<Object> list = listObjsByCondition(condition, wrapper);
        return ResultConvert.convertListToResult(list,converter);
    }

    public <V> Result listObjsResultByCondition(CONDITION condition, Converter converter, Function<? super Object, V> mapper) {
        List<V> list = listObjsByCondition(condition, mapper);
        return ResultConvert.convertListToResult(list,converter);
    }

    public <V> Result listObjsResultByCondition(CONDITION condition, Converter converter, Function<? super Object, V> mapper, QueryWrapper<MODEL> wrapper) {
        List<V> list = listObjsByCondition(condition, mapper, wrapper);
        return ResultConvert.convertListToResult(list,converter);
    }
    //</editor-fold>

    //<editor-fold desc="page">
    public Result pageResultByCondition(CONDITION condition, Converter converter) {
        IPage<MODEL> page = pageByCondition(condition);
        return ResultConvert.convertPageToResult(page,converter);
    }

    public Result pageResultByCondition(CONDITION condition, Converter converter, QueryWrapper<MODEL> wrapper) {
        IPage<MODEL> page = pageByCondition(condition, wrapper);
        return ResultConvert.convertPageToResult(page,converter);
    }

    public Result pageMapsResultByCondition(CONDITION condition, Converter converter) {
        IPage<Map<String, Object>> page = pageMapsByCondition(condition);
        return ResultConvert.convertPageToResult(page,converter);
    }

    public Result pageMapsResultByCondition(CONDITION condition, Converter converter, QueryWrapper<MODEL> wrapper) {
        IPage<Map<String, Object>> page = pageMapsByCondition(condition, wrapper);
        return ResultConvert.convertPageToResult(page,converter);
    }
    //</editor-fold>

    //</editor-fold>

    //<editor-fold desc="buildConditon">
    public QueryWrapper<MODEL> buildQueryCondition(CONDITION condition) {
        QueryWrapper<MODEL> wrapper = new QueryWrapper<>();
        return buildQueryCondition(condition, wrapper);
    }

    public QueryWrapper<MODEL> buildQueryCondition(CONDITION condition, QueryWrapper<MODEL> wrapper) {
        if (wrapper == null) {
            wrapper = new QueryWrapper<>();
        }
        return (QueryWrapper<MODEL>) buildWhereCondition(condition, wrapper);
    }

    public UpdateWrapper<MODEL> buildUpdateCondition(CONDITION condition, UpdateWrapper<MODEL> wrapper) {
        return (UpdateWrapper<MODEL>) buildWhereCondition(condition, wrapper);
    }

    public <R, Children extends AbstractWrapper<MODEL, R, Children>> AbstractWrapper<MODEL, R, Children> buildWhereCondition(CONDITION condition, AbstractWrapper<MODEL, R, Children> wrapper) {
        throw new NotImplementedException();
    }
    //</editor-fold>
}

