package cn.net.vidyo.dylink.mybatis.plus.service;

import cn.net.vidyo.dylink.mybatis.plus.dao.EntityDao;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import org.apache.ibatis.annotations.Param;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface EntityService<DAO extends EntityDao<MODEL>, MODEL, KEY extends Serializable> extends IService<MODEL> {

    DAO getEntityDao();
    void setEntityDao(DAO entityDao);

    //<editor-fold desc="Description">

    int truncate();
    int drop();
    int insert(MODEL entity);
    boolean update(MODEL entity);

    boolean delete(MODEL entity);

    int deleteById(Serializable id);

    int deleteByMap(@Param("cm") Map<String, Object> columnMap);

    int deleteByWhere(@Param("ew") Wrapper<MODEL> wrapper);

    int deleteBatchIds(@Param("coll") Collection<? extends Serializable> idList);

    MODEL selectById(Serializable id);

    List<MODEL> selectBatchIds(@Param("coll") Collection<? extends Serializable> idList);

    List<MODEL> selectByMap(@Param("cm") Map<String, Object> columnMap);

    MODEL selectOneByWhere(@Param("ew") Wrapper<MODEL> queryWrapper);

    long selectCountByWhere(@Param("ew") Wrapper<MODEL> queryWrapper);

    List<MODEL> selectListByWhere(@Param("ew") Wrapper<MODEL> queryWrapper);

    List<Map<String, Object>> selectMapsByWhere(@Param("ew") Wrapper<MODEL> queryWrapper);

    List<Object> selectObjsByWhere(@Param("ew") Wrapper<MODEL> queryWrapper);

    <E extends IPage<MODEL>> E selectPageByWhere(E page, @Param("ew") Wrapper<MODEL> queryWrapper);

    <E extends IPage<Map<String, Object>>> E selectMapsPageByWhere(E page, @Param("ew") Wrapper<MODEL> queryWrapper);
    //</editor-fold>
    //<editor-fold desc="Description">
    List<MODEL> findByIds(Collection<KEY> ids);

    MODEL getByName(String name);

    String getNameById(KEY id);

    <C> C getColumnById(Class<C> cClass, KEY id, String fileName);

    List<KEY> findIdsByWhere(String columName, QueryWrapper<MODEL> where);

    <C> List<C> findColumnsByWhere(String columName,Class<C> cClass, QueryWrapper<MODEL> where);
    <C> C getColumnsByWhere(String columName,Class<C> cClass, QueryWrapper<MODEL> where);

    int logicDeleteByIds(boolean hidden, KEY... ids);
    //</editor-fold>




}
