package cn.net.vidyo.dylink.mybatis.plus.service;




import cn.net.vidyo.dylink.mybatis.plus.dao.EntityDao;
import cn.net.vidyo.framework.common.data.domain.Condition;
import cn.net.vidyo.framework.common.data.domain.Converter;
import cn.net.vidyo.framework.common.domain.Result;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public interface EntityConditionService<DAO extends EntityDao<MODEL>, MODEL, KEY extends Serializable, CONDITION extends Condition> extends EntityService<DAO, MODEL, KEY> {
    //<editor-fold desc="base conditon">

    //<editor-fold desc="get">
    MODEL getOneByCondition(CONDITION condition);

    Map<String, Object> getMapByCondition(CONDITION condition);

    <V> V getObjByCondition(CONDITION condition, Function<? super Object, V> mapper) ;
    //</editor-fold>

    //<editor-fold desc="list">
    public List<KEY> findIdsByCondition(CONDITION condition);
    List<MODEL> listByCondition(CONDITION condition);

    List<Map<String, Object>> listMapsByCondition(CONDITION condition);

    List<Map<String, Object>> listMapsByCondition(CONDITION condition, QueryWrapper<MODEL> wrapper);

    List<Object> listObjsByCondition(CONDITION condition);

    List<Object> listObjsByCondition(CONDITION condition, QueryWrapper<MODEL> wrapper);

    <V> List<V> listObjsByCondition(CONDITION condition, Function<? super Object, V> mapper);

    <V> List<V> listObjsByCondition(CONDITION condition, Function<? super Object, V> mapper, QueryWrapper<MODEL> wrapper);
    //</editor-fold>

    //<editor-fold desc="page">
    IPage<MODEL> pageByCondition(CONDITION condition);

    IPage<MODEL> pageByCondition(CONDITION condition, QueryWrapper<MODEL> wrapper);

    IPage<Map<String, Object>> pageMapsByCondition(CONDITION condition);

    IPage<Map<String, Object>> pageMapsByCondition(CONDITION condition, QueryWrapper<MODEL> wrapper);
    //</editor-fold>

    //<editor-fold desc="count">
    long countByCondition(CONDITION condition);
    //</editor-fold>


    //<editor-fold desc="update">
    boolean updateByCondition(CONDITION condition, UpdateWrapper<MODEL> updateWrapper) ;
    boolean incrementColumnByCondition(CONDITION condition, String column, Serializable delta);


    //</editor-fold>

    //<editor-fold desc="delete">
    boolean deleteByCondition(CONDITION condition);

    boolean logicDeleteByCondition(CONDITION condition, boolean hidden);
    //</editor-fold>

    //</editor-fold>

    //<editor-fold desc="result conditon">

    //<editor-fold desc="get">
    Result getOneResultByCondition(CONDITION condition, Converter converter) ;

    Result getMapResultByCondition(CONDITION condition, Converter converter);

    <V> Result getObjResultByCondition(CONDITION condition, Converter converter, Function<? super Object, V> mapper) ;
    //</editor-fold>

    //<editor-fold desc="list">
    Result listResultByCondition(CONDITION condition, Converter converter);

    Result listMapsResultByCondition(CONDITION condition, Converter converter);

    Result listMapsResultByCondition(CONDITION condition, Converter converter, QueryWrapper<MODEL> wrapper) ;

    Result listObjsResultByCondition(CONDITION condition, Converter converter);

    Result listObjsResultByCondition(CONDITION condition, Converter converter, QueryWrapper<MODEL> wrapper);

    <V> Result listObjsResultByCondition(CONDITION condition, Converter converter, Function<? super Object, V> mapper);

    <V> Result listObjsResultByCondition(CONDITION condition, Converter converter, Function<? super Object, V> mapper, QueryWrapper<MODEL> wrapper);
    //</editor-fold>

    //<editor-fold desc="page">
    Result pageResultByCondition(CONDITION condition, Converter converter);
    Result pageResultByCondition(CONDITION condition, Converter converter, QueryWrapper<MODEL> wrapper);

    Result pageMapsResultByCondition(CONDITION condition, Converter converter);

    Result pageMapsResultByCondition(CONDITION condition, Converter converter, QueryWrapper<MODEL> wrapper);
    //</editor-fold>

    //</editor-fold>

    //<editor-fold desc="buildConditon">
    QueryWrapper<MODEL> buildQueryCondition(CONDITION condition);

    QueryWrapper<MODEL> buildQueryCondition(CONDITION condition, QueryWrapper<MODEL> wrapper) ;

    UpdateWrapper<MODEL> buildUpdateCondition(CONDITION condition, UpdateWrapper<MODEL> wrapper);

    <R, Children extends AbstractWrapper<MODEL, R, Children>> AbstractWrapper<MODEL, R, Children> buildWhereCondition(CONDITION condition, AbstractWrapper<MODEL, R, Children> wrapper) ;
    //</editor-fold>
}
