package cn.net.vidyo.dylink.mongdb.service;

import cn.net.vidyo.framework.common.data.domain.Condition;
import cn.net.vidyo.framework.common.util.ValueUtil;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MongodbEntityConditionService<MODEL, CONDITION extends Condition> extends MongodbEntityService<MODEL> implements IMongodbEntityConditionService<MODEL,CONDITION>{

    public MODEL getByQuery(CONDITION condition) {
        Query query = buildWhereCondition(condition);
        return (MODEL) entityDao.getByQuery(query,modelClass);
    }
    public List<MODEL> findByQuery(CONDITION condition) {
        Query query = buildWhereCondition(condition);
        return entityDao.findByQuery(query,modelClass);
    }
    public Page<MODEL> pageByQuery(CONDITION condition) {
        Query query = buildWhereCondition(condition);
        return entityDao.pageByQuery(query,modelClass,condition.getPageNumber(),condition.getPageSize());
    }

    public <COLUMN> COLUMN getByQuery(Class<COLUMN> modelClass,CONDITION condition) {
        Query query = buildWhereCondition(condition);
        return (COLUMN) entityDao.getByQuery(query,modelClass);
    }
    public <COLUMN> List<COLUMN> findColumnByQuery(Class<COLUMN> modelClass,CONDITION condition) {
        Query query = buildWhereCondition(condition);
        return entityDao.findByQuery(query,modelClass);
    }
    public <COLUMN> Page<COLUMN> pageColumnByQuery(Class<COLUMN> modelClass,CONDITION condition) {
        Query query = buildWhereCondition(condition);
        return entityDao.pageByQuery(query,modelClass,condition.getPageNumber(),condition.getPageSize());
    }
    public long updateByQuery(MODEL model, CONDITION condition) {
        Query query = buildWhereCondition(condition);
        Update update = buildUpdateCondition(condition);
        return entityDao.updateByQuery(query,update,modelClass);
    }
    public long deleteByQuery(CONDITION condition) {
        Query query = buildWhereCondition(condition);
        return entityDao.deleteByQuery(query,modelClass);
    }

    protected Query buildWhereCondition(CONDITION condition) {
        throw new NotImplementedException();
    }
    protected Update buildUpdateCondition(CONDITION condition) {
        throw new NotImplementedException();
    }


    public <RESULT> RESULT getColumnByCondition(CONDITION condition, Class<RESULT> resultClass,String columName){
        Query query = buildWhereCondition(condition);
        return entityDao.getColumnByQuery(query,resultClass,getCollectionName(),columName);
    }
    public <RESULT> RESULT getColumnByCondition(CONDITION condition, Class<RESULT> resultClass,boolean exclude,List<String> fields){
        Query query = buildWhereCondition(condition);
        return entityDao.getColumnByQuery(query,resultClass,getCollectionName(),exclude,fields);
    }
    public <RESULT> List<RESULT> findColumnByCondition(CONDITION condition, Class<RESULT> resultClass,String columName){
        Query query = buildWhereCondition(condition);
        return entityDao.findColumnByQuery(query,resultClass,getCollectionName(),columName);
    }
    public <RESULT> List<RESULT> findColumnByCondition(CONDITION condition, Class<RESULT> resultClass,boolean exclude,List<String> fields){
        Query query = buildWhereCondition(condition);
        return entityDao.findColumnByQuery(query,resultClass,getCollectionName(),exclude,fields);
    }
    public <RESULT> Page<RESULT> pageColumnByCondition(CONDITION condition, Class<RESULT> resultClass,String columnName,int pageNumber,int pageSize){
        Query query = buildWhereCondition(condition);
        return entityDao.pageColumnByQuery(query,resultClass,getCollectionName(),columnName,pageNumber,pageSize);
    }
    public <RESULT> Page<RESULT> pageColumnByCondition(CONDITION condition, Class<RESULT> resultClass, boolean exclude, List<String> fields, int pageNumber, int pageSize){
        Query query = buildWhereCondition(condition);
        return entityDao.pageColumnByQuery(query,resultClass,getCollectionName(),exclude,fields,pageNumber,pageSize);
    }


    public LinkedHashMap<String,Object> getColumnMapByCondition(CONDITION condition,String columName){
        Object value = getColumnByCondition(condition, Object.class, columName);
        if(value==null){
            return new LinkedHashMap<>();
        }
        return (LinkedHashMap<String,Object>)value;
    }
    public LinkedHashMap<String,Object> getColumnMapByCondition(CONDITION condition,boolean exclude,List<String> fields){
        Object value = getColumnByCondition(condition, Object.class, exclude,fields);
        if(value==null){
            return new LinkedHashMap<>();
        }
        return (LinkedHashMap<String,Object>)value;
    }
    public List<LinkedHashMap<String,Object>> findColumnMapByCondition(CONDITION condition,String columName){
        List<Object> values = findColumnByCondition(condition, Object.class, columName);
        if(values==null){
            return new ArrayList<>();
        }
        List<LinkedHashMap<String,Object>> list = new ArrayList<>();
        for (Object value : values) {
            list.add((LinkedHashMap<String,Object>)value);
        }
        return list;
    }
    public List<LinkedHashMap<String,Object>> findColumnMapByCondition(CONDITION condition,boolean exclude,List<String> fields){
        List<Object> values = findColumnByCondition(condition, Object.class, exclude,fields);
        if(values==null){
            return new ArrayList<>();
        }
        List<LinkedHashMap<String,Object>> list = new ArrayList<>();
        for (Object value : values) {
            list.add((LinkedHashMap<String,Object>)value);
        }
        return list;
    }
    public Page<LinkedHashMap<String,Object>> pageColumnMapByCondition(CONDITION condition,String columnName,int pageNumber,int pageSize){
        Page<Object> dbPage = pageColumnByCondition(condition, Object.class, columnName,pageNumber,pageSize);
        List<Object> values=dbPage.getContent();
        List<LinkedHashMap<String,Object>> list = new ArrayList<>();
        for (Object value : values) {
            list.add((LinkedHashMap<String,Object>)value);
        }
        Pageable pageable= PageRequest.of(pageNumber,pageSize);
        return new PageImpl<LinkedHashMap<String,Object>>(list,pageable,dbPage.getTotalElements());
    }
    public Page<LinkedHashMap<String,Object>> pageColumnMapByCondition(CONDITION condition, boolean exclude, List<String> fields, int pageNumber, int pageSize){
        Page<Object> dbPage = pageColumnByCondition(condition, Object.class, exclude,fields,pageNumber,pageSize);
        List<Object> values=dbPage.getContent();
        List<LinkedHashMap<String,Object>> list = new ArrayList<>();
        for (Object value : values) {
            list.add((LinkedHashMap<String,Object>)value);
        }
        Pageable pageable= PageRequest.of(pageNumber,pageSize);
        return new PageImpl<LinkedHashMap<String,Object>>(list,pageable,dbPage.getTotalElements());
    }




//    public <COLUMN> COLUMN  getColumnValueByCondition(CONDITION condition, Class<COLUMN> resultClass,String columName){
//        Object val = getColumnMapByCondition(condition, columName);
//        LinkedHashMap map =(LinkedHashMap)val;
//        if(map.containsKey(columName)){
//            ValueUtil.getPrimitiveInstance()
//        }
//        Query query = buildWhereCondition(condition);
//        return entityDao.getColumnByQuery(query,Object.class,getCollectionName(),columName);
//    }
//    public <COLUMN> List<COLUMN> findColumnValueByCondition(CONDITION condition, Class<COLUMN> resultClass,String columName){
//        Query query = buildWhereCondition(condition);
//        return entityDao.findColumnByQuery(query,Object.class,getCollectionName(),columName);
//    }
//    public <COLUMN> Page<COLUMN> pageColumnValueByCondition(CONDITION condition, Class<COLUMN> resultClass,String columnName,int pageNumber,int pageSize){
//        Query query = buildWhereCondition(condition);
//        return entityDao.pageColumnByQuery(query,Object.class,getCollectionName(),columnName,pageNumber,pageSize);
//    }
}
