package cn.net.vidyo.dylink.mongdb.service;

import cn.net.vidyo.framework.common.data.domain.Condition;
import org.springframework.data.domain.Page;
import org.springframework.data.mongodb.core.query.Query;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public interface IMongodbEntityConditionService<MODEL, CONDITION extends Condition> {

    MODEL getByQuery(CONDITION condition);
    List<MODEL> findByQuery(CONDITION condition);
    long updateByQuery(MODEL model, CONDITION condition);
    long deleteByQuery(CONDITION condition);
    Page<MODEL> pageByQuery(CONDITION condition);

    <RESULT> RESULT getColumnByCondition(CONDITION condition, Class<RESULT> resultClass,String columName);
    <RESULT> RESULT getColumnByCondition(CONDITION condition, Class<RESULT> resultClass,boolean exclude,List<String> fields);
    <RESULT> List<RESULT> findColumnByCondition(CONDITION condition, Class<RESULT> resultClass,String columName);
    <RESULT> List<RESULT> findColumnByCondition(CONDITION condition, Class<RESULT> resultClass,boolean exclude,List<String> fields);
    <RESULT> Page<RESULT> pageColumnByCondition(CONDITION condition, Class<RESULT> resultClass,String columnName,int pageNumber,int pageSize);
    <RESULT> Page<RESULT> pageColumnByCondition(CONDITION condition, Class<RESULT> resultClass, boolean exclude, List<String> fields, int pageNumber, int pageSize);

    LinkedHashMap<String,Object> getColumnMapByCondition(CONDITION condition,String columName);
    LinkedHashMap<String,Object> getColumnMapByCondition(CONDITION condition,boolean exclude,List<String> fields);
    List<LinkedHashMap<String,Object>> findColumnMapByCondition(CONDITION condition,String columName);
    List<LinkedHashMap<String,Object>> findColumnMapByCondition(CONDITION condition,boolean exclude,List<String> fields);
    Page<LinkedHashMap<String,Object>> pageColumnMapByCondition(CONDITION condition,String columnName,int pageNumber,int pageSize);
    Page<LinkedHashMap<String,Object>> pageColumnMapByCondition(CONDITION condition, boolean exclude, List<String> fields, int pageNumber, int pageSize);

//    <COLUMN> COLUMN getColumnValueByCondition(CONDITION condition, Class<COLUMN> resultClass,String columName);
//    <COLUMN> List<COLUMN> findColumnValueByCondition(CONDITION condition, Class<COLUMN> resultClass,String columName);
//    <COLUMN> Page<COLUMN> pageColumnValueByCondition(CONDITION condition, Class<COLUMN> resultClass,String columnName,int pageNumber,int pageSize);
}
