package cn.net.vidyo.dylink.mongdb.dao;

import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Field;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

import java.util.*;

public class MongodbEntityDao {
    @Autowired
    public MongoTemplate mongoTemplate;

    public MongodbEntityDao() {
    }

    public Object save(Object model) {
        return mongoTemplate.save(model);
    }
    public Object insert(Object model) {
        return mongoTemplate.insert(model);
    }
    public Object update(Object model) {
        return mongoTemplate.save(model);
    }

    public <MODEL> List<MODEL> findAll(Class<MODEL> modelClass) {
        return mongoTemplate.findAll(modelClass);
    }
    public <MODEL> MODEL getByQuery(Query query, Class<MODEL> modelClass) {
        return mongoTemplate.findOne(query, modelClass);
    }
    public <MODEL> List<MODEL> findByQuery(Query query, Class<MODEL> modelClass) {
        return mongoTemplate.find(query, modelClass);
    }
    public <MODEL> MODEL getByQuery(Query query, Class<MODEL> modelClass,boolean exclude,List<String> fields ) {
        Field findFields = query.fields();
        if(fields!=null && fields.size()>0) {
            if (exclude) {
                fields.forEach(findFields::exclude);
            } else {
                fields.forEach(findFields::include);
            }
        }
        return mongoTemplate.findOne(query, modelClass);
    }
    public <MODEL> List<MODEL> findByQuery(Query query, Class<MODEL> modelClass,boolean exclude,List<String> fields) {
        Field findFields = query.fields();
        if(fields!=null && fields.size()>0) {
            if (exclude) {
                fields.forEach(findFields::exclude);
            } else {
                fields.forEach(findFields::include);
            }
        }
        return mongoTemplate.find(query, modelClass);
    }

    public <RESULT> RESULT getColumnByQuery(Query query, Class<RESULT> resultClass,String collectionName, String columnName) {
        List<String> fields=new ArrayList<>();
        fields.add(columnName);
        return getColumnByQuery(query,resultClass,collectionName,false,fields);
    }
    public <RESULT> RESULT getColumnByQuery(Query query, Class<RESULT> modelClass,String collectionName,boolean exclude,List<String> fields) {
        Field findFields = query.fields();
        if(fields!=null && fields.size()>0) {
            if (exclude) {
                fields.forEach(findFields::exclude);
            } else {
                fields.forEach(findFields::include);
            }
        }
        return mongoTemplate.findOne(query, modelClass,collectionName);
    }
    public <RESULT> List<RESULT> findColumnByQuery(Query query, Class<RESULT> resultClass,String collectionName, String columnName) {
        List<String> fields=new ArrayList<>();
        fields.add(columnName);
        return findColumnByQuery(query,resultClass,collectionName,false,fields);
    }
    public <RESULT> List<RESULT> findColumnByQuery(Query query, Class<RESULT> modelClass,String collectionName,boolean exclude,List<String> fields) {
        Field findFields = query.fields();
        if(fields!=null && fields.size()>0) {
            if (exclude) {
                fields.forEach(findFields::exclude);
            } else {
                fields.forEach(findFields::include);
            }
        }
        return mongoTemplate.find(query, modelClass,collectionName);
    }

    public <MODEL> Page<MODEL> pageByQuery(Query query, Class<MODEL> modelClass,int pageNumber,int pageSize) {
        long count = mongoTemplate.count(query, modelClass);
        Pageable pageable = PageRequest.of(pageNumber, pageSize);
        int skip = (pageNumber-1)*pageSize;
        query.skip(skip);// skip相当于从那条记录开始
        query.limit(pageSize);// 从skip开始,取多少条记录
        List<MODEL> models = mongoTemplate.find(query, modelClass);
        return new PageImpl<MODEL>(models, pageable, count);
    }

    public <MODEL> Page<MODEL> pageByQuery(Query query, Class<MODEL> modelClass,boolean exclude,List<String> fields,int pageNumber,int pageSize) {
        long count = mongoTemplate.count(query, modelClass);
        Pageable pageable = PageRequest.of(pageNumber, pageSize);
        int skip = (pageNumber-1)*pageSize;
        query.skip(skip);// skip相当于从那条记录开始
        query.limit(pageSize);// 从skip开始,取多少条记录
        Field findFields = query.fields();
        if(fields!=null && fields.size()>0) {
            if (exclude) {
                fields.forEach(findFields::exclude);
            } else {
                fields.forEach(findFields::include);
            }
        }
        List<MODEL> models = mongoTemplate.find(query, modelClass);
        return new PageImpl<MODEL>(models, pageable, count);
    }
    public <RESULT> Page<RESULT> pageColumnByQuery(Query query, Class<RESULT> resultClass,String collectionName, String columnName, int pageNumber, int pageSize) {
        List<String> fields=new ArrayList<>();
        fields.add(columnName);
        return pageColumnByQuery(query,resultClass,collectionName,false,fields,pageNumber,pageSize);
    }
    public <RESULT> Page<RESULT> pageColumnByQuery(Query query, Class<RESULT> resultClass,String collectionName, boolean exclude, List<String> fields, int pageNumber, int pageSize) {
        long count = mongoTemplate.count(query, resultClass);
        Pageable pageable = PageRequest.of(pageNumber, pageSize);
        int skip = (pageNumber-1)*pageSize;
        query.skip(skip);// skip相当于从那条记录开始
        query.limit(pageSize);// 从skip开始,取多少条记录
        Field findFields = query.fields();
        if(fields!=null && fields.size()>0) {
            if (exclude) {
                fields.forEach(findFields::exclude);
            } else {
                fields.forEach(findFields::include);
            }
        }
        List<RESULT> models = mongoTemplate.find(query, resultClass,collectionName);
        return new PageImpl<RESULT>(models, pageable, count);
    }

    public long updateByQuery(Query query, Update update, Class modelClass) {
        UpdateResult updateResult = mongoTemplate.updateMulti(query, update, modelClass);
        return updateResult.getMatchedCount();
    }

    public long deleteByQuery(Query query, Class modelClass) {
        DeleteResult remove = mongoTemplate.remove(query, modelClass);
        return remove.getDeletedCount();
    }
}
