package cn.net.vidyo.dylink.mongdb.service;

import cn.net.vidyo.framework.common.data.domain.Condition;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.data.domain.Page;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

import java.util.List;

public class MongodbEntityConditionService<MODEL, CONDITION extends Condition> extends MongodbEntityService<MODEL> implements IMongodbEntityConditionService<MODEL,CONDITION>{

    public MODEL getByQuery(CONDITION condition) {
        Query query = buildWhereCondition(condition);
        return (MODEL) entityDao.getByQuery(query,modelClass);
    }
    public List<MODEL> findByQuery(CONDITION condition) {
        Query query = buildWhereCondition(condition);
        return entityDao.findByQuery(query,modelClass);
    }
    public Page<MODEL> pageByQuery(CONDITION condition) {
        Query query = buildWhereCondition(condition);
        return entityDao.pageByQuery(query,modelClass,condition.getPageNumber(),condition.getPageSize());
    }
    public long updateByQuery(MODEL model, CONDITION condition) {
        Query query = buildWhereCondition(condition);
        Update update = buildUpdateCondition(condition);
        return entityDao.updateByQuery(query,update,modelClass);
    }
    public long deleteByQuery(CONDITION condition) {
        Query query = buildWhereCondition(condition);
        return entityDao.deleteByQuery(query,modelClass);
    }

    protected Query buildWhereCondition(CONDITION condition) {
        throw new NotImplementedException();
    }
    protected Update buildUpdateCondition(CONDITION condition) {
        throw new NotImplementedException();
    }
}
