package cn.net.vidyo.dylink.mongdb.dao;

import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import java.util.List;

public class MongodbEntityDao<MODEL> {
    @Autowired
    private MongoTemplate mongoTemplate;

    public MongodbEntityDao() {
    }

    public Object save(Object model) {
        return mongoTemplate.save(model);
    }
    public Object insert(Object model) {
        return mongoTemplate.insert(model);
    }
    public Object update(Object model) {
        return mongoTemplate.save(model);
    }

    public <MODEL> MODEL getByQuery(Query query, Class<MODEL> modelClass) {
        return mongoTemplate.findOne(query, modelClass);
    }

    public <MODEL> List<MODEL> findAll(Class<MODEL> modelClass) {
        return mongoTemplate.findAll(modelClass);
    }

    public <MODEL> List<MODEL> findByQuery(Query query, Class<MODEL> modelClass) {
        return mongoTemplate.find(query, modelClass);
    }

    public <MODEL> Page<MODEL> pageByQuery(Query query, Class<MODEL> modelClass,int pageNumber,int pageSize) {
        long count = mongoTemplate.count(query, modelClass);
        Pageable pageable = PageRequest.of(pageNumber, pageSize);
        int skip = (pageNumber-1)*pageSize;
        query.skip(skip);// skip相当于从那条记录开始
        query.limit(pageSize);// 从skip开始,取多少条记录
        List<MODEL> models = mongoTemplate.find(query, modelClass);
        return new PageImpl<MODEL>(models, pageable, count);
    }

    public long updateByQuery(Query query, Update update, Class modelClass) {
        UpdateResult updateResult = mongoTemplate.updateMulti(query, update, modelClass);
        return updateResult.getMatchedCount();
    }

    public long deleteByQuery(Query query, Class modelClass) {
        DeleteResult remove = mongoTemplate.remove(query, modelClass);
        return remove.getDeletedCount();
    }
}
