package cn.net.vidyo.dylink.mongdb.service;

import cn.hutool.core.bean.BeanUtil;
import cn.net.vidyo.dylink.mongdb.dao.MongodbEntityDao;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.ObjectUtils;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;

public class MongodbEntityService<MODEL> implements IMongodbEntityService<MODEL>{
    @Autowired
    MongodbEntityDao entityDao;
    Class<MODEL> modelClass;

    public MongodbEntityService() {
        modelClass=(Class<MODEL>)((ParameterizedType)getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public MODEL getById(Serializable id) {
        Query query=new Query();
        query.addCriteria(Criteria.where("id").is(id));
        return getByQuery(query);
    }

    public MODEL save(MODEL model) {
        return (MODEL)entityDao.save(model);
    }
    public MODEL insert(MODEL model) {
        return (MODEL)entityDao.insert(model);
    }
    public MODEL update(MODEL model) {
        return updateById(model);
    }
    public MODEL updateById(MODEL model) {
        Object value = BeanUtil.getFieldValue(model, "id");
        Query query=Query.query(Criteria.where("id").is(value));
        return (MODEL)entityDao.update(model);
    }
    public long deleteById(Serializable id) {
        Query query=new Query();
        query.addCriteria(Criteria.where("id").is(id));
        return deleteByQuery(query);
    }
    public List<MODEL> findAll() {
        return entityDao.findAll(modelClass);
    }
    public List<MODEL> findByIds(List ids) {
        Query query=Query.query(Criteria.where("id").in(ids));
        return findByQuery(query);
    }

    //<editor-fold desc="protected">
    protected MODEL getByQuery(Query query) {
        return (MODEL) entityDao.getByQuery(query,modelClass);
    }
    protected List<MODEL> findByQuery(Query query) {
        return entityDao.findByQuery(query,modelClass);
    }
    protected <MODEL> Page<MODEL> pageByQuery(Query query, int pageNumber, int pageSize){
        return entityDao.pageByQuery(query,modelClass,pageNumber,pageSize);
    }
    protected long updateByQuery(Query query, Update update) {
        return entityDao.updateByQuery(query, update, modelClass);
    }
    protected long deleteByQuery(Query query) {
        return entityDao.deleteByQuery(query,modelClass);
    }
    //</editor-fold>
}
