package cn.net.vidyo.dylink.mongdb.dao;

import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

public class QueryHelper {
    public static void eq(Query query,boolean condition,String key,Object value){
        if(!condition) return;
        Criteria criteria = Criteria.where(key).is(value);
        query.addCriteria(criteria);
    }
    public static void eqByString(Query query,String key,String value){
        eq(query,value!=null && value.length()>0,key,value);
    }
    public static void eqByInt(Query query,String key,int value){
        eq(query,value>0,key,value);
    }
    public static void eqByLong(Query query,String key,long value){
        eq(query,value>0,key,value);
    }
    public static void bothTime(Query query,boolean condition,String key,long begintime,long endtime){
        if(!condition) return;
        Criteria posttime = Criteria.where(key);
        if(begintime>0) {
            posttime.gte(begintime);
        }
        if(endtime>0) {
            posttime.lte(endtime);
        }
        query.addCriteria(posttime);
    }
}
