/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.data.jpa.dao.support;

import cn.net.vidyo.framework.data.jpa.dao.EntityEventCallback;
import cn.net.vidyo.framework.data.jpa.dao.Event;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;

public class DefaultEntityEventCallback
implements EntityEventCallback {
    static Map<Class, Map<Event, Method>> classEventMethodMap = new LinkedHashMap<Class, Map<Event, Method>>();

    public static Map<Event, Method> getClassEventMethods(Class aClass) {
        if (classEventMethodMap.containsKey(aClass)) {
            return classEventMethodMap.get(aClass);
        }
        Map<Event, Method> eventMap = DefaultEntityEventCallback.getEventMap(aClass);
        classEventMethodMap.put(aClass, eventMap);
        return eventMap;
    }

    public static Method getClassEventMethod(Class aClass, Event event) {
        Map<Event, Method> eventMethods = DefaultEntityEventCallback.getClassEventMethods(aClass);
        if (eventMethods.containsKey((Object)event)) {
            return eventMethods.get((Object)event);
        }
        return null;
    }

    public static <T> Map<Event, Method> getEventMap(Class<T> clazz) {
        HashMap<Event, Method> ret = new HashMap<Event, Method>();
        for (Class<T> superclazz = clazz; superclazz != null && !superclazz.equals(Object.class); superclazz = superclazz.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = superclazz.getMethods()) {
                if (!ret.containsKey((Object)Event.PrePersist) && method.getAnnotation(PrePersist.class) != null) {
                    ret.put(Event.PrePersist, method);
                    continue;
                }
                if (!ret.containsKey((Object)Event.PreUpdate) && method.getAnnotation(PreUpdate.class) != null) {
                    ret.put(Event.PreUpdate, method);
                    continue;
                }
                if (!ret.containsKey((Object)Event.PreDelete) && method.getAnnotation(PreRemove.class) != null) {
                    ret.put(Event.PreDelete, method);
                    continue;
                }
                if (!ret.containsKey((Object)Event.PostLoad) && method.getAnnotation(PostLoad.class) != null) {
                    ret.put(Event.PostLoad, method);
                    continue;
                }
                if (!ret.containsKey((Object)Event.PostPersist) && method.getAnnotation(PostPersist.class) != null) {
                    ret.put(Event.PostPersist, method);
                    continue;
                }
                if (!ret.containsKey((Object)Event.PostUpdate) && method.getAnnotation(PostUpdate.class) != null) {
                    ret.put(Event.PostUpdate, method);
                    continue;
                }
                if (ret.containsKey((Object)Event.PostDelete) || method.getAnnotation(PostRemove.class) == null) continue;
                ret.put(Event.PostDelete, method);
            }
        }
        return ret;
    }

    @Override
    public void batchInvokeEvent(Collection targets, Event event) {
        if (targets.isEmpty()) {
            return;
        }
        for (Object target : targets) {
            this.invokeEvent(target, event);
        }
    }

    @Override
    public void invokeEvent(Object target, Event event) {
        if (target == null) {
            return;
        }
        Method method = DefaultEntityEventCallback.getClassEventMethod(target.getClass(), event);
        if (method != null) {
            try {
                method.invoke(target, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

