package cn.net.vidyo.framework.data.jpa.dao.sql;

import cn.net.vidyo.framework.data.jpa.domain.Condition;
import org.springframework.data.domain.Pageable;

import java.util.ArrayList;
import java.util.List;

public class QueryWrapper extends WhereWrapper{
    String selectSql ="*";
    String tableName="";
    int pageNumber=1;
    int pageSize=20;

    public QueryWrapper() {
    }

    public QueryWrapper(String where, Object... params) {
        super(where, params);
    }
    public QueryWrapper(String select,String where,  Object... params) {
        super(where, params);
        this.selectSql = select;
    }
    public QueryWrapper select(String select, String alias, SqlSelect pattern){
        return select(true,select,alias,pattern);
    }
    public QueryWrapper select(boolean condition,String select, String alias, SqlSelect pattern){
        if(!condition) return this;
        StringBuilder sql = new StringBuilder();
        if(select.length()>1){
            sql.append(this.selectSql);
            sql.append(",");
        }
        switch (pattern) {
            case TEAM:
                sql.append(select);
                break;
            case COUNT:
                sql.append(" COUNT( ").append(select).append(")");
                break;
            case SUM:
                sql.append(" SUM( ").append(select).append(")");
                break;
            case MIN:
                sql.append(" MIN( ").append(select).append(")");
                break;
            case MAX:
                sql.append(" MAX( ").append(select).append(")");
                break;
            case LEN:
                sql.append(" LEN( ").append(select).append(")");
                break;
            case AVG:
                sql.append(" AVG( ").append(select).append(")");
                break;
            case FIRST:
                sql.append(" FIRST( ").append(select).append(")");
                break;
            case LAST:
                sql.append(" LAST( ").append(select).append(")");
                break;
            case ALL:
                sql.append(" * ");
                break;
            default:
                throw new RuntimeException("pattern value is fail");
        }
        if(alias!=null && alias.length()>0){
            sql.append(" as ");
            sql.append(alias);
        }
        this.selectSql =sql.toString();
        return this;
    }

    public void setPageable(Condition condition){
        this.pageNumber=condition.getPageNumber();
        this.pageSize=condition.getPageSize();
    }
    public void setPageable(Pageable pageable){
        this.pageNumber=pageable.getPageNumber();
        this.pageSize=pageable.getPageSize();
    }
    @Override
    public String getSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append(selectSql.toString());
        sql.append(" FROM ");
        sql.append(tableName);
        if(whereSql.length()>0) {
            sql.append(" WHERE ");
            sql.append(whereSql.toString());
        }
        return sql.toString();
    }
    public String getCountSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT count(*) ");
        sql.append(" FROM ");
        sql.append(tableName);
        if(whereSql.length()>0) {
            sql.append(" WHERE ");
            sql.append(whereSql.toString());
        }
        return sql.toString();
    }
    public String getPageSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append(selectSql.toString());
        sql.append(" FROM ");
        sql.append(tableName);
        if(whereSql.length()>0) {
            sql.append(" WHERE ");
            sql.append(whereSql.toString());
        }
        sql.append(" LIMIT ");
        if(pageNumber<1) pageNumber=1;
        sql.append((pageNumber-1)*pageSize);
        sql.append(",");
        sql.append(pageSize);
        return sql.toString();
    }

    @Override
    public List getSqlParams() {
        List sqlParams = new ArrayList();
        sqlParams.addAll(whereParams);
        return sqlParams;
    }

    public String getSelectSql() {
        return selectSql;
    }

    public void setSelectSql(String selectSql) {
        this.selectSql = selectSql;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public int getPageNumber() {
        return pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}
