package cn.net.vidyo.framework.data.jpa.service;

import cn.net.vidyo.framework.data.jpa.dao.sql.DeleteWrapper;
import cn.net.vidyo.framework.data.jpa.dao.sql.QueryWrapper;
import cn.net.vidyo.framework.data.jpa.dao.sql.UpdateWrapper;
import cn.net.vidyo.framework.data.jpa.dao.sql.WhereWrapper;
import cn.net.vidyo.framework.data.jpa.domain.Condition;
import cn.net.vidyo.framework.data.jpa.dao.CommonJpaRepository;
import cn.net.vidyo.framework.data.jpa.dao.ConditionCompose;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

public interface EntityConditionService<
        CONDITION extends Condition,
        DAO extends CommonJpaRepository<T, ID>,
        T, ID extends Serializable>
        extends EntityService<DAO,T,ID>{
    //<editor-fold desc="query object">
    Object getColumn(String columnName, CONDITION condition);
    T getModel(CONDITION condition);

    <C> C getColumn(Class<C> cClass, String columnName, CONDITION condition);
    Map getMap(CONDITION condition);
    Object getObject(String select, CONDITION condition);

    //</editor-fold>
    //<editor-fold desc="query object list">
    List<T> queryModels(CONDITION condition);
    <C> List<C> queryColumns(Class<C> cClass, CONDITION condition);
    List<Map> queryMaps(CONDITION condition);
    List queryObjects(String select,CONDITION condition);

    //</editor-fold>
    //<editor-fold desc="query object page">
    Page<T> pageQueryModels(CONDITION condition);
    Page pageQueryObjects(String select,CONDITION condition);
    <C> Page<C> pageQueryColumns(Class<C> cClass, CONDITION condition);
    Page<Map> pageQueryMaps(CONDITION condition);

    //</editor-fold>

    //<editor-fold desc="buildConditon">
    QueryWrapper buildQueryCondition(CONDITION condition);

    QueryWrapper buildQueryCondition(CONDITION condition, QueryWrapper wrapper) ;

    UpdateWrapper buildUpdateCondition(CONDITION condition, UpdateWrapper wrapper);
    DeleteWrapper buildDeleteCondition(CONDITION condition, DeleteWrapper wrapper);

    WhereWrapper buildWhereCondition(CONDITION condition, WhereWrapper wrapper) ;
    //</editor-fold>
}
