package cn.net.vidyo.framework.data.jpa.dao.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UpdateWrapper extends WhereWrapper{
    StringBuilder updateSql=new StringBuilder();
    List updateParams=new ArrayList();
    String tableName="";
    public UpdateWrapper() {
    }

    public UpdateWrapper(String where, Object... params) {
        super(where, params);
    }


    public UpdateWrapper set(String column,Object value){
        return set(true,column,value);
    }
    public UpdateWrapper set(boolean condition,String column,Object value){
        return set(condition,column,"?",value);
    }
    public UpdateWrapper set(boolean condition,String column,String valueFormat,Object... params){
        if(!condition) return this;
        if(updateSql.length()>0){
            updateSql.append(",");
        }
        updateSql.append(column);
        updateSql.append("=");
        updateSql.append(valueFormat);
        if(params!=null){
            for (Object param : params) {
                updateParams.add(param);
            }
        }
        return this;
    }
    public UpdateWrapper set(boolean condition, Map columnNameValues){
        if(!condition) return this;
        if(columnNameValues!=null){
            for (Object key : columnNameValues.keySet()) {
                set(key.toString(),columnNameValues.get(key));
            }
        }
        return this;
    }
    public UpdateWrapper setSql(boolean condition,String sql,Object... params){
        if(!condition) return this;
        updateSql=new StringBuilder();
        updateSql.append(sql);
        if(params!=null){
            for (Object param : params) {
                updateParams.add(param);
            }
        }
        return this;
    }

    @Override
    public String getSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append(tableName);
        sql.append(" SET ");
        sql.append(updateSql.toString());
        if(whereSql.length()>0) {
            sql.append(" WHERE ");
            sql.append(whereSql.toString());
        }
        return sql.toString();
    }

    @Override
    public List getSqlParams() {
        List sqlParams = new ArrayList();
        sqlParams.addAll(updateParams);
        sqlParams.addAll(whereParams);
        return sqlParams;
    }

    public StringBuilder getUpdateSql() {
        return updateSql;
    }

    public void setUpdateSql(StringBuilder updateSql) {
        this.updateSql = updateSql;
    }

    public List getUpdateParams() {
        return updateParams;
    }

    public void setUpdateParams(List updateParams) {
        this.updateParams = updateParams;
    }



    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}
