package cn.net.vidyo.framework.common.domain;

import java.io.Serializable;

/**
 * Created by laochai on 2020/3/12.
 */
public class Result implements Serializable {
    private static final long serialVersionUID = 4633451373316892528L;
    //
    public boolean success = true;

    public int code = 200;

    // 响应业务状态
    public int status = 0;
    // 响应消息
    public String message = "操作成功";

    // 响应数据
    public Object data = null;

    /**
     * <p>
     * Title: 响应失败
     * </p>
     *
     * @return Result
     */
    public static Result Fail() {
        return Fail(CommonErrorEnum.PARAMETER_ERROR);
    }

    /**
     * <p>
     * Title: 响应失败
     * </p>
     *
     * @param EnumCodes dd
     * @return Result
     */
    public static Result Fail(IErrorEnum EnumCodes) {
        return Fail(EnumCodes, null);
    }

    /**
     * <p>
     * Title: 响应失败
     * </p>
     * @param payload  dd
     * @param EnumCodes dd
     * @return Result
     */
    public static Result Fail(IErrorEnum EnumCodes, Object payload) {
        return Fail(EnumCodes.getDisplay(), EnumCodes.getCode(), payload);
    }

    public static Result Fail(String message,int code) {
        return Fail(message, code, null);
    }

    /**
     * <p>
     * Title: 响应失败，但是自定义响应消息l
     * </p>
     *
     * @param msg     需要自定义的响应消息
     * @param code    code
     * @param payload 数据
     * @return Result
     */
    public static Result Fail(String msg, int code, Object payload) {
        return bulid(code, msg, payload, false, 400);
    }

    /**
     * <p>
     * Title: 成功并且传递数据，并且自定义响应消息内容
     * </p>
     *
     * @param data 响应数据
     * @return Result
     */
    public static Result Success(Object data) {
        return bulid(200, "操作成功", data, true, 0);
    }

    /**
     * <p>
     * Title: 成功，不传递信息，也不自定义信息
     * </p>
     *
     * @return Result
     */
    public static Result Success() {
        return Success(null);
    }

    /**
     * <p>
     * Title: 自定义响应结构
     * </p>
     *
     * @param status d   响应状态
     * @param msg     响应消息
     * @param data    响应数据
     * @param code    ss
     * @param success ss
     * @return Result
     */
    public static Result bulid(int code, String msg, Object data, boolean success, int status) {
        return new Result(code, msg, data, success, status);
    }


    public Result() {
        super();
    }

    /**
     * s
     *
     * @param status d   s
     * @param msg     s
     * @param data    s
     * @param success s
     * @param code    s
     */
    public Result(int code, String msg, Object data, boolean success, int status) {
        super();
        this.status = status;
        this.message = msg;
        this.data = data;
        this.success = success;
        this.code = code;
    }

    /**
     * s
     *
     * @return the status
     */
    public int getStatus() {
        return status;
    }

    /**
     * @param status d  the status to set
     */
    public void setStatus(int status) {
        this.status = status;
    }

    /**
     * @return the msg
     */
    public String getMessage() {
        return message;
    }

    /**
     * @param message the msg to set
     */
    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * @return the data
     */
    public Object getData() {
        return data;
    }

    /**
     * @param data the data to set
     */
    public void setData(Object data) {
        this.data = data;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    /*
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return "Result [status=" + status + ", msg=" + message + ", data=" + data + "]";
    }
}
