package cn.net.vidyo.framework.common.domain;

public enum CommonErrorEnum implements IErrorEnum {


    PARAMETER_ERROR(1200,"参数错误"),

    NOT_EXIST(1201,"不存在"),
    ALREADY(1202,"已经存在"),
    IS_EMPT(1203,"空置"),

    InvalidArgumentFault(1001, "InvalidArgumentFault."),
    GeneralFault(1002, "GeneralFault."),
    RemoteException(1003, "RemoteException"),
    NotLicensedFault(1004, "NotLicensedFault."),
    AuthFaild(1005, "auth faild."),
    ExecuteFaild(1006, "execute faild."),
    NullValue(1007, "null value."),
    RoomAlreadyExists(1008, "RoomAlreadyExists."),
    UserAlreadyExists(1009, "UserAlreadyExists."),
    RoomNotExists(1010, "RoomNotExists."),
    UserNotExists(1011, "UserNotExists."),


    DB_ACCESS_EXCEPTION(1403,"DB操作错误"),

    UNKNOW(999999,"未知")

    ;

    int code=0;
    String display="";

    CommonErrorEnum(int code, String display) {
        this.code = code;
        this.display = display;
    }

    @Override
    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    @Override
    public String getDisplay() {
        return display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }
}
