package cn.net.vidyo.framework.common.data.domain;

import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import java.io.Serializable;

public abstract class BaseModel<KEY extends Serializable> implements Model<KEY> {
//    @TableLogic
    private Boolean hidden=false;

    private Long createtime=0L;

    private Long  updatetime=0L;

    public Boolean isHidden() {
        return hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public Long getCreatetime() {
        return createtime;
    }

    public void setCreatetime(Long createtime) {
        this.createtime = createtime;
    }

    public Long getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(Long updatetime) {
        this.updatetime = updatetime;
    }


    @PrePersist
    @Override
    public void preInsert() {
        hidden=false;
        createtime=System.currentTimeMillis();
    }

    @PreUpdate
    @Override
    public void preUpdate() {
        updatetime=System.currentTimeMillis();
    }

    @PostLoad
    @Override
    public void postLoad() {
    }


}
