/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.common.util;

import cn.net.vidyo.framework.common.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ClassUtils;

public class ValueUtil {
    private static final Pattern CAPITAL_MODE = Pattern.compile("^[0-9A-Z/_]+$");
    private static final int MAX_POWER_OF_TWO = 0x40000000;

    public static void putMapMoneyItem(Map data, String key, long money) {
        ValueUtil.putMapMoneyItem(data, key, money, true);
    }

    public static void putMapMoneyItem(Map data, String key, long money, boolean isAddMoneyString) {
        data.put(key, money);
        if (isAddMoneyString) {
            data.put(key + "String", ValueUtil.money100IntToStringMoney(money));
        }
    }

    public static String convertTimeToString(long time) {
        if (time == 0L) {
            return "";
        }
        Date date = new Date(time);
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        String format = f.format(date);
        return format;
    }

    public static boolean checkIsNumber(String content) {
        try {
            Double num1 = Double.parseDouble(content);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static Date UTCToCST(String UTCStr) throws ParseException {
        return ValueUtil.UTCToCST(UTCStr, "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    }

    public static Date UTCToCST(String UTCStr, String format) throws ParseException {
        Date date = null;
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        date = sdf.parse(UTCStr);
        System.out.println("UTC\u65f6\u95f4: " + date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(10, calendar.get(10) + 8);
        return calendar.getTime();
    }

    public static String convertMoneyString(int money) {
        double d = money / 100;
        return String.valueOf(d);
    }

    public static long convertStringToMoneyLong(String content) {
        double v = ValueUtil.toDouble(content, 0.0);
        return (long)(v *= 100.0);
    }

    public static String convertMoneyLongToMoneyString(long money) {
        double val = money;
        String content = String.valueOf(val /= 100.0);
        if (content.indexOf(".") < 0) {
            content = content + ".00";
        }
        if (content.endsWith(".0")) {
            content = content + "0";
        }
        content = "\u00a5" + content;
        return content;
    }

    public static String convertMoneyLongToNegativeMoneyString(long money) {
        double val = money;
        String content = String.valueOf(val /= 100.0);
        if (content.indexOf(".") < 0) {
            content = content + ".00";
        }
        if (content.endsWith(".0")) {
            content = content + "0";
        }
        content = "\u00a5-" + content;
        return content;
    }

    public static Date mapItemToDate(Map data, String key, Date defaultValue) {
        String content = ValueUtil.mapItemToString(data, key, "");
        if (content.length() == 0) {
            return defaultValue;
        }
        if (content.length() < 10) {
            return defaultValue;
        }
        try {
            return ValueUtil.UTCToCST(content);
        }
        catch (ParseException e) {
            return defaultValue;
        }
    }

    public static int mapItemToInt(Map data, String key) {
        return ValueUtil.mapItemToInt(data, key, 0);
    }

    public static int mapItemToInt(Map data, String key, int defaultValue) {
        if (data == null || !data.containsKey(key)) {
            return defaultValue;
        }
        return ValueUtil.toInt(data.get(key), defaultValue);
    }

    public static long mapItemToLong(Map data, String key) {
        return ValueUtil.mapItemToLong(data, key, 0L);
    }

    public static long mapItemToLong(Map data, String key, long defaultValue) {
        if (data == null || !data.containsKey(key)) {
            return defaultValue;
        }
        return ValueUtil.toLong(data.get(key), defaultValue);
    }

    public static boolean mapItemToBool(Map data, String key) {
        return ValueUtil.mapItemToBool(data, key, false);
    }

    public static boolean mapItemToBool(Map data, String key, boolean defaultValue) {
        if (data == null || !data.containsKey(key)) {
            return defaultValue;
        }
        return ValueUtil.toBool(data.get(key), defaultValue);
    }

    public static String mapItemToString(Map data, String key) {
        return ValueUtil.mapItemToString(data, key, "");
    }

    public static String mapItemToString(Map data, String key, String defaultValue) {
        if (data == null || !data.containsKey(key)) {
            return defaultValue;
        }
        return data.get(key).toString();
    }

    public static double mapItemToDouble(Map data, String key) {
        return ValueUtil.mapItemToDouble(data, key, 0.0);
    }

    public static double mapItemToDouble(Map data, String key, double defaultValue) {
        if (data == null || !data.containsKey(key)) {
            return defaultValue;
        }
        return ValueUtil.toDouble(data.get(key), defaultValue);
    }

    public static Date mapItemToStandardDate(Map data, String key) {
        return ValueUtil.mapItemToStandardDate(data, key, null);
    }

    public static Date mapItemToStandardDate(Map data, String key, Date defaultValue) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return ValueUtil.mapItemToDate(data, key, df, defaultValue);
    }

    public static Date mapItemToDate(Map data, String key, SimpleDateFormat simpleDateFormat, Date defaultValue) {
        if (data == null || !data.containsKey(key)) {
            return defaultValue;
        }
        return ValueUtil.toDate(data.get(key), simpleDateFormat, defaultValue);
    }

    public static long mapItemMoneyTo100IntMoney(Map data, String key) {
        return ValueUtil.mapItemMoneyTo100IntMoney(data, key, 0L);
    }

    public static long mapItemMoneyTo100IntMoney(Map data, String key, long defaultValue) {
        if (data == null || !data.containsKey(key)) {
            return defaultValue;
        }
        return ValueUtil.moneyStringTo100IntMoney(data.get(key), defaultValue);
    }

    public static String dateToString(long time) {
        Date date = new Date(time);
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        String format = f.format(new Date(time));
        return format;
    }

    public static long stringToLongDate(String timeString) {
        return 0L;
    }

    public static Date toDate(Object value) {
        return ValueUtil.toDate(value, null);
    }

    public static Date toDate(Object value, Date defaultValue) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return ValueUtil.toDate(value, df, defaultValue);
    }

    public static Date toDate(Object value, SimpleDateFormat simpleDateFormat, Date defaultValue) {
        String s = ValueUtil.toString(value);
        if (s.length() == 0) {
            return defaultValue;
        }
        try {
            Date date = simpleDateFormat.parse(s);
            return date;
        }
        catch (ParseException e) {
            return defaultValue;
        }
    }

    public static String toString(Object value) {
        return ValueUtil.toString(value, "");
    }

    public static String toString(Object value, String defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    public static int toInt(Object value) {
        return ValueUtil.toInt(value, 0);
    }

    public static int toInt(Object value, int defaultValue) {
        String s = ValueUtil.toString(value, "");
        if (s == null || s.length() == 0) {
            return defaultValue;
        }
        if (s.endsWith(".0")) {
            s = s.substring(0, s.length() - 2);
        }
        if (s.indexOf("E") > 0) {
            Long aLong = ValueUtil.scienceToLong(s);
            return aLong.intValue();
        }
        if (s.indexOf("e") > 0) {
            Long aLong = ValueUtil.scienceToLong(s);
            return aLong.intValue();
        }
        return Integer.valueOf(s);
    }

    public static boolean toBool(Object value) {
        return ValueUtil.toBool(value, false);
    }

    public static boolean toBool(Object value, boolean defaultValue) {
        String s = ValueUtil.toString(value, "");
        if (s == null || s.length() == 0) {
            return defaultValue;
        }
        return Boolean.valueOf(s);
    }

    public static long toLong(Object value) {
        return ValueUtil.toLong(value, 0L);
    }

    public static long toLong(Object value, long defaultValue) {
        String s = ValueUtil.toString(value, "");
        if (s == null || s.length() == 0) {
            return defaultValue;
        }
        if (s.endsWith(".0")) {
            s = s.substring(0, s.length() - 2);
        }
        if (s.indexOf("E") > 0) {
            return ValueUtil.scienceToLong(s);
        }
        if (s.indexOf("e") > 0) {
            return ValueUtil.scienceToLong(s);
        }
        return Long.valueOf(s);
    }

    public static double toDouble(Object data) {
        return ValueUtil.toDouble(data, 0.0);
    }

    public static double toDouble(Object data, double defaultValue) {
        String value = ValueUtil.toString(data, "");
        if (value == "") {
            return defaultValue;
        }
        return Double.valueOf(value);
    }

    public static short toShort(Object data) {
        short val = 0;
        return ValueUtil.toShort(data, val);
    }

    public static short toShort(Object data, short defaultValue) {
        String value = ValueUtil.toString(data, "");
        if (value == "") {
            return defaultValue;
        }
        value = value.replace(".0", "");
        return Short.valueOf(value);
    }

    public static boolean toBoolean(Object data) {
        return ValueUtil.toBoolean(data, false);
    }

    public static boolean toBoolean(Object data, boolean defaultValue) {
        String value = ValueUtil.toString(data, "");
        if (value == "") {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public static char toChar(Object data) {
        return ValueUtil.toChar(data, '0');
    }

    public static char toChar(Object data, char defaultValue) {
        String value = ValueUtil.toString(data, "");
        if (value == "") {
            return defaultValue;
        }
        return value.charAt(0);
    }

    public static byte toByte(Object data) {
        byte val = 0;
        return ValueUtil.toByte(data, val);
    }

    public static byte toByte(Object data, byte defaultValue) {
        String value = ValueUtil.toString(data, "");
        if (value == "") {
            return defaultValue;
        }
        return Byte.parseByte(value);
    }

    public static <E extends Enum<E>> E toEnum(Object data, Class<E> eClass, E defaultValue) {
        String value = ValueUtil.toString(data, "");
        if (value == "") {
            return defaultValue;
        }
        return Enum.valueOf(eClass, value);
    }

    public static <E extends Enum<E>> E toEnum(Object data, Class<E> eClass) {
        return ValueUtil.toEnum(data, eClass, null);
    }

    public static List<Integer> listMaptoListInt(List<LinkedHashMap<String, Object>> list, String key) {
        ArrayList<Integer> items = new ArrayList<Integer>();
        if (list == null) {
            return items;
        }
        for (Map map : list) {
            items.add(ValueUtil.mapItemToInt(map, key));
        }
        return items;
    }

    public static List<Long> listMaptoListLong(List<LinkedHashMap<String, Object>> list, String key) {
        ArrayList<Long> items = new ArrayList<Long>();
        if (list == null) {
            return items;
        }
        for (Map map : list) {
            items.add(ValueUtil.mapItemToLong(map, key));
        }
        return items;
    }

    public static Long scienceToLong(String str) {
        BigDecimal demical = new BigDecimal(str);
        return demical.longValue();
    }

    public static BigDecimal toBigDecimal(Object value) {
        double v = ValueUtil.toDouble(value, 0.0);
        return BigDecimal.valueOf(v);
    }

    public static long moneyStringTo100IntMoney(Object value) {
        return ValueUtil.moneyStringTo100IntMoney(value, 0L);
    }

    public static long moneyStringTo100IntMoney(Object value, long defaultValue) {
        BigDecimal v = ValueUtil.toBigDecimal(value);
        BigDecimal b = BigDecimal.valueOf(100L);
        v = v.multiply(b);
        try {
            return v.longValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String money100IntToStringMoney(Object value) {
        return ValueUtil.money100IntToStringMoney(value, "0.00");
    }

    public static String money100IntToStringMoney(Object value, String defaultValue) {
        BigDecimal v = ValueUtil.toBigDecimal(value);
        BigDecimal b = BigDecimal.valueOf(100L);
        v = v.divide(b);
        b = v.setScale(2, RoundingMode.HALF_UP);
        try {
            return "\u00a5" + b + "";
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String filterEmoji(String nick_name) {
        if (nick_name == null) {
            return nick_name;
        }
        Pattern emoji = Pattern.compile("[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\ud83e\udc00-\ud83e\udfff]|[\u2600-\u27ff]", 66);
        Matcher emojiMatcher = emoji.matcher(nick_name);
        if (emojiMatcher.find()) {
            nick_name = emojiMatcher.replaceAll("*");
            return nick_name;
        }
        return nick_name;
    }

    public static boolean isNumeric(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmail(String string) {
        if (string == null) {
            return false;
        }
        String regEx1 = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
        Pattern p = Pattern.compile(regEx1);
        Matcher m = p.matcher(string);
        return m.matches();
    }

    public static boolean isMobile(String phone) {
        String regex = "^1\\d{10}$";
        boolean flag = false;
        try {
            phone = phone.replaceAll(" ", "");
            if (StringUtils.isEmpty(phone)) {
                return flag;
            }
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(phone);
            flag = matcher.matches();
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
        return flag;
    }

    public static boolean isCapitalMode(String word) {
        return null != word && CAPITAL_MODE.matcher(word).matches();
    }

    public static boolean isMixedMode(String word) {
        return ValueUtil.matches(".*[A-Z]+.*", word) && ValueUtil.matches(".*[/_]+.*", word);
    }

    public static String firstToLowerCase(String param) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)param)) {
            return "";
        }
        return param.substring(0, 1).toLowerCase() + param.substring(1);
    }

    private static int capacity(int expectedSize) {
        if (expectedSize < 3) {
            if (expectedSize < 0) {
                throw new IllegalArgumentException("expectedSize cannot be negative but was: " + expectedSize);
            }
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            return (int)((float)expectedSize / 0.75f + 1.0f);
        }
        return Integer.MAX_VALUE;
    }

    public static <K, V> HashMap<K, V> newHashMapWithExpectedSize(int expectedSize) {
        return new HashMap(ValueUtil.capacity(expectedSize));
    }

    public static boolean matches(String regex, String input) {
        if (null == regex || null == input) {
            return false;
        }
        return Pattern.matches(regex, input);
    }

    public static String firstCapitalLetterName(String name) {
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        return name;
    }

    public static String firstLowercaseLetterName(String name) {
        name = name.substring(0, 1).toLowerCase() + name.substring(1);
        return name;
    }

    public static Object getPrimitiveInstance(Class returnType) {
        Character res = null;
        if (returnType == null || returnType == Void.TYPE) {
            return res;
        }
        if (returnType.isPrimitive() || ClassUtils.wrapperToPrimitive((Class)returnType) != null) {
            Class wrapper = ClassUtils.primitiveToWrapper((Class)returnType);
            if (wrapper == Character.class) {
                res = Character.valueOf('0');
            } else {
                try {
                    res = wrapper.getConstructor(String.class).newInstance("0");
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return res;
    }

    public static boolean compareParimitiveWithWrapper(Class clazz01, Class clazz02) {
        if (clazz01 == clazz02) {
            return true;
        }
        if (clazz01.isPrimitive()) {
            return clazz02 == ClassUtils.primitiveToWrapper((Class)clazz01);
        }
        if (clazz02.isPrimitive()) {
            return clazz01 == ClassUtils.primitiveToWrapper((Class)clazz02);
        }
        return false;
    }
}

