/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.hibernate.management.impl.BeanUtils;

public class ListUtil {
    public static <T> List<T> flatten(List<?> list) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object o : list) {
            if (o instanceof List) {
                List<T> subResult = ListUtil.flatten((List)o);
                result.addAll(subResult);
                continue;
            }
            result.add(o);
        }
        return result;
    }

    public static <T> List<T> compact(List<T> list) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : list) {
            if (t == null) continue;
            result.add(t);
        }
        return result;
    }

    public static <T, R> List<R> map(List<T> list, String property) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (T t : list) {
            try {
                Object r = ListUtil.getProperty(t, property);
                result.add(r);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static <K, V> Map<K, V> toMap(List<V> list, String keyProperty) {
        HashMap<Object, V> map = new HashMap<Object, V>(100);
        for (V v : list) {
            try {
                Object k = ListUtil.getProperty(v, keyProperty);
                map.put(k, v);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public static <T> List<T> filter(List<T> list, String property, Object value) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : list) {
            try {
                Object v = ListUtil.getProperty(t, property);
                if ((v != null || value != null) && (v == null || !v.equals(value))) continue;
                result.add(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static <T> List<T> without(List<T> list, T value) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : list) {
            if (value == null && t == null || value != null && value.equals(t)) continue;
            result.add(t);
        }
        return result;
    }

    public static <T> List<T> uniq(List<T> input) {
        LinkedHashMap<T, T> map = new LinkedHashMap<T, T>();
        for (T t : input) {
            map.put(t, t);
        }
        return new ArrayList(map.values());
    }

    public static <K, T> List<T> sortBy(List<T> input, String keyProperty, List<K> keys) {
        if (input.isEmpty()) {
            return new ArrayList();
        }
        Map<K, T> map = ListUtil.toMap(input, keyProperty);
        ArrayList<T> result = new ArrayList<T>();
        for (K k : keys) {
            T t = map.get(k);
            if (t == null) continue;
            result.add(t);
        }
        return result;
    }

    public static <K, V> Map<K, List<V>> group(List<V> input, String keyProperty) {
        HashMap<Object, List> result = new HashMap<Object, List>(100);
        for (V v : input) {
            try {
                Object k = ListUtil.getProperty(v, keyProperty);
                List list = result.computeIfAbsent(k, k1 -> new ArrayList());
                list.add(v);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static <T> List<List<T>> group(List<T> input, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n must > 0");
        }
        int size = input.size();
        int m = (size + n - 1) / n;
        ArrayList<List<T>> result = new ArrayList<List<T>>(m);
        for (int i = 0; i < m; ++i) {
            ArrayList<T> items = new ArrayList<T>(n);
            int end = i < m - 1 ? n : size - i * n;
            for (int j = 0; j < end; ++j) {
                items.add(input.get(i * n + j));
            }
            result.add(items);
        }
        return result;
    }

    public static boolean containAny(Set parent, Set<Object> child) {
        if (parent == null || child == null) {
            return false;
        }
        Iterator<Object> iterator = child.iterator();
        if (iterator.hasNext()) {
            Object o = iterator.next();
            return parent.contains(o);
        }
        return false;
    }

    public static <V> List<V> newArrayList(V ... vs) {
        ArrayList<V> list = new ArrayList<V>();
        list.addAll(Arrays.asList(vs));
        return list;
    }

    public static String concat(List list, String str) {
        StringBuilder builder = new StringBuilder();
        for (Object obj : list) {
            builder.append(obj.toString()).append(str);
        }
        return builder.substring(0, builder.toString().length() - 1);
    }

    private static Object getProperty(Object bean, String name) {
        return BeanUtils.getBeanProperty((Object)bean, (String)name);
    }
}

